<?php
/**
 * The template for displaying single agent posts
 *
 * @package Elite_Realty
 */

get_header();

while ( have_posts() ) :
    the_post();
    
    // Get custom fields - assuming ACF is used
    $phone = get_field('phone');
    $email = get_field('email');
    $position = get_field('position');
    $years_experience = get_field('years_experience');
    $facebook_url = get_field('facebook_url');
    $instagram_url = get_field('instagram_url');
    $linkedin_url = get_field('linkedin_url');
    $twitter_url = get_field('twitter_url');
    
    // About section fields
    $about_description = get_field('about_description');
    $education = get_field('education');
    $languages = get_field('languages');
    $philosophy_quote = get_field('philosophy_quote');
    $total_sales = get_field('total_sales');
    $happy_clients = get_field('happy_clients');
    
    // Expertise areas (repeater field)
    $expertise_areas = get_field('expertise_areas');
    
    // Testimonials (repeater field)
    $testimonials = get_field('testimonials');
    
    // Recent transactions (repeater field)
    $recent_transactions = get_field('recent_transactions');
    
    // Office information
    $office_location = get_field('office_location');
    $office_address = get_field('office_address');
    $working_hours = get_field('working_hours');
    ?>

    <!-- Hero Section -->
    <section class="agent-hero min-h-screen flex items-center justify-center relative">
        <div class="w-full max-w-7xl mx-auto px-6">
            <div class="grid md:grid-cols-5 gap-12 items-center">
                <div class="md:col-span-2">
                    <?php if ( has_post_thumbnail() ) : ?>
                        <?php the_post_thumbnail( 'large', array( 'class' => 'w-full rounded-2xl shadow-2xl' ) ); ?>
                    <?php else : ?>
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/agent-placeholder.jpg" alt="<?php the_title(); ?>" class="w-full rounded-2xl shadow-2xl">
                    <?php endif; ?>
                    
                    <div class="bg-white/90 backdrop-blur-sm rounded-xl p-6 mt-6 shadow-lg">
                        <div class="grid grid-cols-2 gap-4">
                            <?php if ( $facebook_url ) : ?>
                                <a href="<?php echo esc_url( $facebook_url ); ?>" class="flex items-center space-x-3 text-gray-700 hover:text-primary transition-colors" target="_blank" rel="noopener">
                                    <div class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded-full">
                                        <i class="ri-facebook-fill text-xl"></i>
                                    </div>
                                    <span class="font-medium">Facebook</span>
                                </a>
                            <?php endif; ?>
                            
                            <?php if ( $instagram_url ) : ?>
                                <a href="<?php echo esc_url( $instagram_url ); ?>" class="flex items-center space-x-3 text-gray-700 hover:text-primary transition-colors" target="_blank" rel="noopener">
                                    <div class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded-full">
                                        <i class="ri-instagram-fill text-xl"></i>
                                    </div>
                                    <span class="font-medium">Instagram</span>
                                </a>
                            <?php endif; ?>
                            
                            <?php if ( $phone ) : ?>
                                <a href="tel:<?php echo esc_attr( $phone ); ?>" class="flex items-center space-x-3 text-gray-700 hover:text-primary transition-colors">
                                    <div class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded-full">
                                        <i class="ri-phone-fill text-xl"></i>
                                    </div>
                                    <span class="font-medium"><?php echo esc_html( $phone ); ?></span>
                                </a>
                            <?php endif; ?>
                            
                            <?php if ( $email ) : ?>
                                <a href="mailto:<?php echo esc_attr( $email ); ?>" class="flex items-center space-x-3 text-gray-700 hover:text-primary transition-colors">
                                    <div class="w-10 h-10 flex items-center justify-center bg-gray-100 rounded-full">
                                        <i class="ri-mail-fill text-xl"></i>
                                    </div>
                                    <span class="font-medium truncate">Email Me</span>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                
                <div class="md:col-span-3 text-white">
                    <h1 class="text-5xl md:text-6xl font-bold mb-4"><?php the_title(); ?></h1>
                    <?php if ( $position ) : ?>
                        <p class="text-2xl mb-2 text-blue-200"><?php echo esc_html( $position ); ?></p>
                    <?php endif; ?>
                    <?php if ( $years_experience ) : ?>
                        <p class="text-xl mb-6 text-blue-100"><?php echo esc_html( $years_experience ); ?> Years of Experience</p>
                    <?php endif; ?>
                    <button class="bg-primary text-white px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold flex items-center space-x-2 !rounded-button whitespace-nowrap" data-agent-consultation>
                        <div class="w-5 h-5 flex items-center justify-center">
                            <i class="ri-phone-line"></i>
                        </div>
                        <span>Schedule Consultation</span>
                    </button>
                </div>
            </div>
        </div>
    </section>

    <!-- About Section -->
    <section class="py-20 bg-white">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid md:grid-cols-2 gap-16 items-center">
                <div>
                    <h2 class="text-4xl font-bold text-gray-900 mb-6">About <?php echo get_the_title(); ?></h2>
                    <?php if ( $about_description ) : ?>
                        <div class="text-lg text-gray-600 mb-6">
                            <?php echo wp_kses_post( $about_description ); ?>
                        </div>
                    <?php endif; ?>
                    
                    <div class="grid grid-cols-2 gap-6">
                        <?php if ( $education ) : ?>
                            <div>
                                <h4 class="font-semibold text-gray-900 mb-2">Education</h4>
                                <p class="text-gray-600"><?php echo wp_kses_post( $education ); ?></p>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $languages ) : ?>
                            <div>
                                <h4 class="font-semibold text-gray-900 mb-2">Languages</h4>
                                <p class="text-gray-600"><?php echo wp_kses_post( $languages ); ?></p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="bg-gradient-to-br from-primary/5 to-secondary/5 rounded-2xl p-8">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">My Philosophy</h3>
                    <?php if ( $philosophy_quote ) : ?>
                        <blockquote class="text-lg text-gray-700 italic mb-6">"<?php echo esc_html( $philosophy_quote ); ?>"</blockquote>
                    <?php endif; ?>
                    
                    <div class="grid grid-cols-3 gap-4 text-center">
                        <?php if ( $total_sales ) : ?>
                            <div class="bg-white rounded-lg p-4">
                                <div class="text-3xl font-bold text-primary mb-1"><?php echo esc_html( $total_sales ); ?></div>
                                <div class="text-sm text-gray-600">Total Sales</div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $happy_clients ) : ?>
                            <div class="bg-white rounded-lg p-4">
                                <div class="text-3xl font-bold text-primary mb-1"><?php echo esc_html( $happy_clients ); ?></div>
                                <div class="text-sm text-gray-600">Happy Clients</div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $years_experience ) : ?>
                            <div class="bg-white rounded-lg p-4">
                                <div class="text-3xl font-bold text-primary mb-1"><?php echo esc_html( $years_experience ); ?>+</div>
                                <div class="text-sm text-gray-600">Years Experience</div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Areas of Expertise -->
    <?php if ( $expertise_areas ) : ?>
        <section class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">Areas of Expertise</h2>
                    <p class="text-xl text-gray-600">Specialized services tailored to your unique needs</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <?php foreach ( $expertise_areas as $area ) : ?>
                        <div class="bg-white rounded-2xl p-8 text-center shadow-lg hover:shadow-xl transition-shadow">
                            <div class="w-16 h-16 flex items-center justify-center bg-primary/10 rounded-full mx-auto mb-6">
                                <i class="<?php echo esc_attr( $area['icon'] ); ?> ri-2x text-primary"></i>
                            </div>
                            <h3 class="text-xl font-bold text-gray-900 mb-4"><?php echo esc_html( $area['title'] ); ?></h3>
                            <p class="text-gray-600"><?php echo esc_html( $area['description'] ); ?></p>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Current Listings -->
    <?php
    // Query for properties where this agent is the listing agent
    $property_args = array(
        'post_type' => 'property',
        'posts_per_page' => 3,
        'meta_query' => array(
            array(
                'key' => 'listing_agent',
                'value' => get_the_ID(),
                'compare' => '='
            )
        ),
        'meta_key' => 'property_status',
        'orderby' => 'meta_value date',
        'order' => 'DESC'
    );
    
    $properties = new WP_Query( $property_args );
    
    if ( $properties->have_posts() ) : ?>
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">Current Listings</h2>
                    <p class="text-xl text-gray-600">Exclusive properties available through <?php the_title(); ?></p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php while ( $properties->have_posts() ) : $properties->the_post(); 
                        $price = get_field('price');
                        $bedrooms = get_field('bedrooms');
                        $bathrooms = get_field('bathrooms');
                        $square_feet = get_field('square_feet');
                        $property_status = get_field('property_status');
                        ?>
                        <div class="listing-card bg-white rounded-2xl overflow-hidden shadow-lg">
                            <div class="relative">
                                <?php if ( has_post_thumbnail() ) : ?>
                                    <?php the_post_thumbnail( 'medium_large', array( 'class' => 'w-full h-64 object-cover object-top' ) ); ?>
                                <?php endif; ?>
                                
                                <?php if ( $property_status ) : ?>
                                    <div class="absolute top-4 left-4 bg-<?php echo $property_status === 'new' ? 'green' : ($property_status === 'reduced' ? 'orange' : 'yellow'); ?>-500 text-white px-3 py-1 rounded-full text-sm font-semibold">
                                        <?php echo esc_html( ucfirst( $property_status ) ); ?>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="absolute top-4 right-4 bg-primary text-white px-3 py-1 rounded-full text-sm font-semibold">Active</div>
                            </div>
                            <div class="p-6">
                                <?php if ( $price ) : ?>
                                    <div class="text-3xl font-bold text-gray-900 mb-2">$<?php echo number_format( $price ); ?></div>
                                <?php endif; ?>
                                <div class="text-gray-600 mb-4"><?php echo get_field('city') . ', ' . get_field('state'); ?></div>
                                <div class="flex items-center space-x-6 text-sm text-gray-500 mb-4">
                                    <?php if ( $bedrooms ) : ?>
                                        <div class="flex items-center space-x-1">
                                            <div class="w-4 h-4 flex items-center justify-center">
                                                <i class="ri-hotel-bed-line"></i>
                                            </div>
                                            <span><?php echo esc_html( $bedrooms ); ?> beds</span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ( $bathrooms ) : ?>
                                        <div class="flex items-center space-x-1">
                                            <div class="w-4 h-4 flex items-center justify-center">
                                                <i class="ri-drop-line"></i>
                                            </div>
                                            <span><?php echo esc_html( $bathrooms ); ?> baths</span>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <?php if ( $square_feet ) : ?>
                                        <div class="flex items-center space-x-1">
                                            <div class="w-4 h-4 flex items-center justify-center">
                                                <i class="ri-aspect-ratio-line"></i>
                                            </div>
                                            <span><?php echo number_format( $square_feet ); ?> sq ft</span>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <a href="<?php the_permalink(); ?>" class="block w-full bg-primary text-white py-3 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap text-center">View Details</a>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </section>
        <?php wp_reset_postdata(); ?>
    <?php endif; ?>

    <!-- Client Testimonials -->
    <?php if ( $testimonials ) : ?>
        <section class="py-20 bg-gray-50">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">Client Testimonials</h2>
                    <p class="text-xl text-gray-600">What my clients say about their experience</p>
                </div>
                <div class="testimonial-slider relative">
                    <div class="testimonial-track" id="testimonialTrack">
                        <?php foreach ( $testimonials as $testimonial ) : ?>
                            <div class="testimonial-card px-4">
                                <div class="bg-white rounded-2xl p-8 shadow-lg">
                                    <div class="flex items-center mb-6">
                                        <?php if ( $testimonial['client_photo'] ) : ?>
                                            <img src="<?php echo esc_url( $testimonial['client_photo']['sizes']['thumbnail'] ); ?>" alt="<?php echo esc_attr( $testimonial['client_name'] ); ?>" class="w-16 h-16 rounded-full object-cover mr-4">
                                        <?php endif; ?>
                                        <div>
                                            <h4 class="font-bold text-gray-900"><?php echo esc_html( $testimonial['client_name'] ); ?></h4>
                                            <p class="text-gray-600"><?php echo esc_html( $testimonial['client_title'] ); ?></p>
                                            <div class="flex text-yellow-400 mt-1">
                                                <?php for ( $i = 0; $i < 5; $i++ ) : ?>
                                                    <i class="ri-star-fill"></i>
                                                <?php endfor; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="text-gray-700 text-lg italic mb-4">"<?php echo esc_html( $testimonial['testimonial_text'] ); ?>"</p>
                                    <div class="text-sm text-gray-500"><?php echo esc_html( $testimonial['transaction_details'] ); ?></div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                    <div class="flex justify-center mt-8 space-x-2">
                        <?php foreach ( $testimonials as $index => $testimonial ) : ?>
                            <button class="w-3 h-3 rounded-full <?php echo $index === 0 ? 'bg-primary' : 'bg-gray-300'; ?> testimonial-dot" data-slide="<?php echo $index; ?>"></button>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Recent Transactions -->
    <?php if ( $recent_transactions ) : ?>
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-6">
                <div class="text-center mb-16">
                    <h2 class="text-4xl font-bold text-gray-900 mb-4">Recent Transactions</h2>
                    <p class="text-xl text-gray-600">Successfully closed deals in the past 6 months</p>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                    <?php foreach ( $recent_transactions as $transaction ) : ?>
                        <div class="transaction-card bg-white rounded-2xl overflow-hidden shadow-lg">
                            <div class="relative">
                                <?php if ( $transaction['property_image'] ) : ?>
                                    <img src="<?php echo esc_url( $transaction['property_image']['sizes']['medium'] ); ?>" alt="Sold Property" class="w-full h-48 object-cover object-top">
                                <?php endif; ?>
                                <div class="absolute top-4 left-4 bg-red-500 text-white px-3 py-1 rounded-full text-sm font-semibold">SOLD</div>
                            </div>
                            <div class="p-4">
                                <div class="text-2xl font-bold text-gray-900 mb-1">$<?php echo number_format( $transaction['sale_price'] ); ?></div>
                                <div class="text-gray-600 text-sm mb-2"><?php echo esc_html( $transaction['location'] ); ?></div>
                                <div class="text-xs text-gray-500">Closed: <?php echo esc_html( $transaction['closing_date'] ); ?></div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Contact Section -->
    <section class="py-20 bg-gray-50">
        <div class="max-w-7xl mx-auto px-6">
            <div class="grid md:grid-cols-2 gap-16">
                <div>
                    <h2 class="text-4xl font-bold text-gray-900 mb-6">Get In Touch</h2>
                    <p class="text-lg text-gray-600 mb-8">Ready to find your dream property or sell your current home? I'm here to help you every step of the way.</p>
                    <div class="space-y-6">
                        <?php if ( $phone ) : ?>
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 flex items-center justify-center bg-primary/10 rounded-full">
                                    <i class="ri-phone-line ri-lg text-primary"></i>
                                </div>
                                <div>
                                    <p class="font-semibold text-gray-900">Direct Line</p>
                                    <p class="text-gray-600"><?php echo esc_html( $phone ); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $email ) : ?>
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 flex items-center justify-center bg-primary/10 rounded-full">
                                    <i class="ri-mail-line ri-lg text-primary"></i>
                                </div>
                                <div>
                                    <p class="font-semibold text-gray-900">Email</p>
                                    <p class="text-gray-600"><?php echo esc_html( $email ); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $office_location && $office_address ) : ?>
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 flex items-center justify-center bg-primary/10 rounded-full">
                                    <i class="ri-map-pin-line ri-lg text-primary"></i>
                                </div>
                                <div>
                                    <p class="font-semibold text-gray-900">Office Location</p>
                                    <p class="text-gray-600"><?php echo esc_html( $office_location ); ?><br><?php echo esc_html( $office_address ); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ( $working_hours ) : ?>
                            <div class="flex items-center space-x-4">
                                <div class="w-12 h-12 flex items-center justify-center bg-primary/10 rounded-full">
                                    <i class="ri-time-line ri-lg text-primary"></i>
                                </div>
                                <div>
                                    <p class="font-semibold text-gray-900">Working Hours</p>
                                    <p class="text-gray-600"><?php echo wp_kses_post( $working_hours ); ?></p>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="flex space-x-4 mt-8">
                        <?php if ( $linkedin_url ) : ?>
                            <a href="<?php echo esc_url( $linkedin_url ); ?>" class="w-10 h-10 flex items-center justify-center bg-primary rounded-full hover:bg-blue-700 transition-colors" target="_blank" rel="noopener">
                                <i class="ri-linkedin-fill text-white"></i>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ( $instagram_url ) : ?>
                            <a href="<?php echo esc_url( $instagram_url ); ?>" class="w-10 h-10 flex items-center justify-center bg-primary rounded-full hover:bg-blue-700 transition-colors" target="_blank" rel="noopener">
                                <i class="ri-instagram-fill text-white"></i>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ( $facebook_url ) : ?>
                            <a href="<?php echo esc_url( $facebook_url ); ?>" class="w-10 h-10 flex items-center justify-center bg-primary rounded-full hover:bg-blue-700 transition-colors" target="_blank" rel="noopener">
                                <i class="ri-facebook-fill text-white"></i>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="bg-white rounded-2xl p-8 shadow-lg">
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Schedule a Consultation</h3>
                    
                    <?php if ( shortcode_exists( 'contact-form-7' ) ) : ?>
                        <?php echo do_shortcode( '[contact-form-7 id="agent-contact-form" title="Agent Contact Form"]' ); ?>
                    <?php else : ?>
                        <form class="agent-contact-form space-y-6" method="post" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>">
                            <?php wp_nonce_field( 'agent_contact_form', 'agent_contact_nonce' ); ?>
                            <input type="hidden" name="action" value="handle_agent_contact">
                            <input type="hidden" name="agent_id" value="<?php echo get_the_ID(); ?>">
                            <input type="hidden" name="agent_name" value="<?php the_title(); ?>">
                            <input type="hidden" name="agent_email" value="<?php echo esc_attr( $email ); ?>">
                            
                            <div class="grid grid-cols-2 gap-4">
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2" for="first_name">First Name</label>
                                    <input type="text" name="first_name" id="first_name" class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm" placeholder="John" required>
                                </div>
                                <div>
                                    <label class="block text-sm font-medium text-gray-700 mb-2" for="last_name">Last Name</label>
                                    <input type="text" name="last_name" id="last_name" class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm" placeholder="Smith" required>
                                </div>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2" for="email">Email Address</label>
                                <input type="email" name="email" id="email" class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm" placeholder="john.smith@email.com" required>
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2" for="phone">Phone Number</label>
                                <input type="tel" name="phone" id="phone" class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm" placeholder="(617) 555-0123">
                            </div>
                            
                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2" for="message">How can I help you?</label>
                                <textarea name="message" id="message" rows="4" class="w-full px-4 py-3 border border-gray-200 rounded-lg focus:outline-none focus:ring-2 focus:ring-primary text-sm" placeholder="Tell me about your property needs..." required></textarea>
                            </div>
                            
                            <button type="submit" class="w-full bg-primary text-white py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold !rounded-button whitespace-nowrap">Send Message</button>
                        </form>
                    <?php endif; ?>
                    
                    <div class="mt-6 p-4 bg-green-50 rounded-lg">
                        <div class="flex items-center space-x-2 text-green-700">
                            <div class="w-5 h-5 flex items-center justify-center">
                                <i class="ri-check-line"></i>
                            </div>
                            <span class="font-semibold">Quick Response Guarantee</span>
                        </div>
                        <p class="text-green-600 text-sm mt-1">I respond to all inquiries within 2 hours during business hours.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="py-20 bg-primary text-white">
        <div class="max-w-7xl mx-auto px-6 text-center">
            <h2 class="text-4xl font-bold mb-4">Ready to Make Your Move?</h2>
            <p class="text-xl mb-8 text-blue-100">Let's discuss your real estate goals and find the perfect solution together.</p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <?php if ( $phone ) : ?>
                    <a href="tel:<?php echo esc_attr( $phone ); ?>" class="bg-white text-primary px-8 py-4 rounded-lg hover:bg-gray-100 transition-colors font-semibold flex items-center justify-center space-x-2 !rounded-button whitespace-nowrap">
                        <div class="w-5 h-5 flex items-center justify-center">
                            <i class="ri-phone-line"></i>
                        </div>
                        <span>Call Now: <?php echo esc_html( $phone ); ?></span>
                    </a>
                <?php endif; ?>
                
                <button class="bg-transparent border-2 border-white text-white px-8 py-4 rounded-lg hover:bg-white hover:text-primary transition-colors font-semibold flex items-center justify-center space-x-2 !rounded-button whitespace-nowrap" data-agent-consultation>
                    <div class="w-5 h-5 flex items-center justify-center">
                        <i class="ri-calendar-line"></i>
                    </div>
                    <span>Schedule Consultation</span>
                </button>
            </div>
        </div>
    </section>

<?php endwhile;

get_footer();