<?php
/**
 * Theme Customizer
 *
 * @package Elite_Northeast_Realty
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Add customizer settings
 */
function elite_realty_customize_register( $wp_customize ) {
    
    // Social Media Section
    $wp_customize->add_section( 'elite_realty_social', array(
        'title'    => __( 'Social Media Links', 'elite-northeast-realty' ),
        'priority' => 120,
    ) );
    
    // Facebook URL
    $wp_customize->add_setting( 'facebook_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( 'facebook_url', array(
        'label'    => __( 'Facebook URL', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_social',
        'type'     => 'url',
    ) );
    
    // Twitter URL
    $wp_customize->add_setting( 'twitter_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( 'twitter_url', array(
        'label'    => __( 'Twitter URL', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_social',
        'type'     => 'url',
    ) );
    
    // Instagram URL
    $wp_customize->add_setting( 'instagram_url', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( 'instagram_url', array(
        'label'    => __( 'Instagram URL', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_social',
        'type'     => 'url',
    ) );
    
    // Contact Information Section
    $wp_customize->add_section( 'elite_realty_contact', array(
        'title'    => __( 'Contact Information', 'elite-northeast-realty' ),
        'priority' => 130,
    ) );
    
    // Contact Phone
    $wp_customize->add_setting( 'contact_phone', array(
        'default'           => '(617) 555-0123',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'contact_phone', array(
        'label'    => __( 'Phone Number', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_contact',
        'type'     => 'text',
    ) );
    
    // Contact Email
    $wp_customize->add_setting( 'contact_email', array(
        'default'           => 'info@eliterealty.com',
        'sanitize_callback' => 'sanitize_email',
    ) );
    
    $wp_customize->add_control( 'contact_email', array(
        'label'    => __( 'Email Address', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_contact',
        'type'     => 'email',
    ) );
    
    // Contact Address
    $wp_customize->add_setting( 'contact_address', array(
        'default'           => 'Boston, MA 02101',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'contact_address', array(
        'label'    => __( 'Address', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_contact',
        'type'     => 'text',
    ) );
    
    // Footer Section
    $wp_customize->add_section( 'elite_realty_footer', array(
        'title'    => __( 'Footer Settings', 'elite-northeast-realty' ),
        'priority' => 140,
    ) );
    
    // Footer Tagline
    $wp_customize->add_setting( 'footer_tagline', array(
        'default'           => 'Your trusted partner in finding the perfect Northeast property.',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'footer_tagline', array(
        'label'    => __( 'Footer Tagline', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_footer',
        'type'     => 'textarea',
    ) );
    
    // Hero Section
    $wp_customize->add_section( 'elite_realty_hero', array(
        'title'    => __( 'Hero Section', 'elite-northeast-realty' ),
        'priority' => 100,
    ) );
    
    // Hero Title
    $wp_customize->add_setting( 'hero_title', array(
        'default'           => 'Find Your Dream Home in the Northeast',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'hero_title', array(
        'label'    => __( 'Hero Title', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_hero',
        'type'     => 'text',
    ) );
    
    // Hero Subtitle
    $wp_customize->add_setting( 'hero_subtitle', array(
        'default'           => 'Discover luxury properties in New England\'s most prestigious neighborhoods',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'hero_subtitle', array(
        'label'    => __( 'Hero Subtitle', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_hero',
        'type'     => 'textarea',
    ) );
    
    // Hero Background Image
    $wp_customize->add_setting( 'hero_background_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'hero_background_image', array(
        'label'    => __( 'Hero Background Image', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_hero',
    ) ) );
    
    // Join Team Section
    $wp_customize->add_section( 'elite_realty_join_team', array(
        'title'    => __( 'Join Team Section', 'elite-northeast-realty' ),
        'priority' => 110,
    ) );
    
    // Join Team Title
    $wp_customize->add_setting( 'join_team_title', array(
        'default'           => 'Join Our Growing Team',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'join_team_title', array(
        'label'    => __( 'Section Title', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'text',
    ) );
    
    // Join Team Description
    $wp_customize->add_setting( 'join_team_description', array(
        'default'           => 'Take your real estate career to the next level with Elite Northeast Realty. We offer industry-leading support, training, and resources to help you succeed.',
        'sanitize_callback' => 'sanitize_textarea_field',
    ) );
    
    $wp_customize->add_control( 'join_team_description', array(
        'label'    => __( 'Section Description', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'textarea',
    ) );
    
    // Join Team Benefits (simplified for now)
    $wp_customize->add_setting( 'join_team_benefits', array(
        'default'           => "Comprehensive training programs\nAdvanced marketing tools and support\nCompetitive commission structure\nAccess to exclusive luxury listings",
        'sanitize_callback' => 'sanitize_textarea_field',
    ) );
    
    $wp_customize->add_control( 'join_team_benefits', array(
        'label'       => __( 'Benefits (one per line)', 'elite-northeast-realty' ),
        'section'     => 'elite_realty_join_team',
        'type'        => 'textarea',
        'description' => __( 'Enter each benefit on a new line', 'elite-northeast-realty' ),
    ) );
    
    // Join Team Button Text
    $wp_customize->add_setting( 'join_team_button_text', array(
        'default'           => 'Start Your Career With Us',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'join_team_button_text', array(
        'label'    => __( 'Button Text', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'text',
    ) );
    
    // Join Team Button URL
    $wp_customize->add_setting( 'join_team_button_url', array(
        'default'           => '#',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( 'join_team_button_url', array(
        'label'    => __( 'Button URL', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'url',
    ) );
    
    // Join Team Image
    $wp_customize->add_setting( 'join_team_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ) );
    
    $wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'join_team_image', array(
        'label'    => __( 'Section Image', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
    ) ) );
    
    // Join Team Stat Number
    $wp_customize->add_setting( 'join_team_stat_number', array(
        'default'           => '95%',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'join_team_stat_number', array(
        'label'    => __( 'Statistic Number', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'text',
    ) );
    
    // Join Team Stat Text
    $wp_customize->add_setting( 'join_team_stat_text', array(
        'default'           => 'Agent satisfaction rate',
        'sanitize_callback' => 'sanitize_text_field',
    ) );
    
    $wp_customize->add_control( 'join_team_stat_text', array(
        'label'    => __( 'Statistic Text', 'elite-northeast-realty' ),
        'section'  => 'elite_realty_join_team',
        'type'     => 'text',
    ) );
}
add_action( 'customize_register', 'elite_realty_customize_register' );

/**
 * Sanitize textarea that may contain line breaks
 */
function elite_realty_sanitize_textarea_with_breaks( $input ) {
    $input = sanitize_textarea_field( $input );
    return $input;
}