# Elite Northeast Realty WordPress Theme

A professional WordPress theme for real estate agencies, converted from static HTML templates.

## Theme Overview

This theme is specifically designed for Elite Northeast Realty, featuring:
- Custom post types for Properties, Agents, and Communities
- Advanced Custom Fields (ACF) integration for easy content management
- Tailwind CSS for modern, responsive design
- AJAX-powered contact forms
- Dynamic property search and filtering
- Agent profiles with testimonials
- Community directory with state-based filtering

## Installation

1. Upload the `elite-realty-theme` folder to `/wp-content/themes/`
2. Activate the theme through the WordPress admin panel
3. Install recommended plugins:
   - Advanced Custom Fields (ACF) - for custom field management
   - Contact Form 7 (optional) - for enhanced form functionality

## Theme Setup

### 1. Menus
Navigate to **Appearance > Menus** and create:
- **Primary Menu** - Main navigation
- **Mobile Menu** - Mobile navigation
- **Footer Properties** - Footer properties links
- **Footer Company** - Footer company links

### 2. Custom Post Types
The theme automatically creates:
- **Properties** - Real estate listings
- **Agents** - Team member profiles  
- **Communities** - Neighborhood/area information

### 3. Theme Customizer
Access via **Appearance > Customize**:
- **Contact Information** - Phone, email, address
- **Social Media** - Facebook, Twitter, Instagram URLs
- **Hero Section** - Homepage hero text and image
- **Join Team Section** - Recruitment section content

### 4. Page Templates
- **About Us** - Custom template for About page
- **Front Page** - Homepage template with all sections

## Required Plugins

### Advanced Custom Fields (ACF)
The theme works best with ACF installed. Import the included field groups or create them manually:

#### Property Fields
- `price` (number)
- `address`, `city`, `state`, `zip` (text)
- `beds`, `baths`, `sqft` (number)
- `gallery_images` (gallery)
- `special_features` (repeater)
- `travel_times` (repeater)
- `interior_features` (repeater)
- `exterior_features` (repeater)

#### Agent Fields
- `phone`, `email`, `position` (text)
- `years_experience` (number)
- `facebook_url`, `twitter_url`, `linkedin_url` (url)
- `about_content` (wysiwyg)
- `expertise_areas` (repeater)
- `testimonials` (repeater)
- `recent_transactions` (repeater)

#### Community Fields
- `community_avg_price` (text)
- `community_active_listings` (number)
- `community_location` (text)
- `community_type` (select)

## Theme Features

### Templates
- `front-page.php` - Homepage with hero, featured properties, team section
- `single-property.php` - Individual property listings
- `single-agent.php` - Agent profile pages
- `archive-community.php` - Community directory
- `page-about.php` - About Us page template
- `search.php` - Search results
- `404.php` - Error page
- `sidebar.php` - Dynamic sidebar

### JavaScript Features
- Property image galleries
- Testimonial sliders
- AJAX contact forms
- Pre-qualification calculator
- Smooth scrolling
- Mobile menu toggle

### Styling
- Tailwind CSS v3.4.16 (CDN)
- Custom CSS for specific components
- Fully responsive design
- Print styles included

## Customization

### Colors
Primary colors defined in custom CSS:
- Navy Blue: `#142A44`
- Gold: `#D4AF37`
- Tailwind blue: `#2563eb`

### Fonts
- Primary: Inter (Google Fonts)
- Accent: Pacifico (Google Fonts)

### Images
The theme uses placeholder images by default. Replace with actual images:
- Upload property images through WordPress media library
- Agent photos use featured images
- Community images use featured images
- Hero backgrounds set via Customizer

## Development

### File Structure
```
elite-realty-theme/
├── assets/
│   ├── css/          # Page-specific styles
│   ├── js/           # JavaScript files
│   └── images/       # Theme images
├── inc/              # PHP includes
├── template-parts/   # Reusable components
└── *.php            # Template files
```

### Hooks & Filters
The theme provides several hooks for customization:
- `elite_realty_before_header`
- `elite_realty_after_header`
- `elite_realty_before_footer`
- `elite_realty_after_footer`

## Support

For theme support and updates:
- Documentation included in `/docs` folder
- Custom field configuration guides
- Template usage examples

## Credits

- Built with WordPress
- Tailwind CSS for styling
- Remix Icons for icons
- Google Fonts for typography

## License

This theme is licensed under GPL v2 or later.