<?php
namespace FlexMLS\Shortcodes;
// Layout class
class sold_Properties_Layout {
    public static function render($listing, $args = []) {
        $main_photo = $args['main_photo'] ?? '';
        $caption = $args['caption'] ?? '';
        $address = $args['address'] ?? '';
        $price = $args['price'] ?? '';
        $mls_id = $args['mls_id'] ?? '';
        $extra_title_line = $args['extra_title_line'] ?? '';
        $img_alt_attr = $args['img_alt_attr'] ?? $caption;
        $relevant_info_line = $args['relevant_info_line'] ?? $price;
        $link_to_start = $args['link_to_start'] ?? '';
        $link_to_end = $args['link_to_end'] ?? '';
        $fmc_send_to = $args['fmc_send_to'] ?? '';

        ob_start();
        ?>
        <div class='flexmls_connect__listing test property-card flex-shrink-0 w-full md:w-1/3 px-3'
             title='<?php echo esc_attr("{$address} | MLS #: {$mls_id} | {$price}{$extra_title_line}"); ?>'>
        <div class='flexmls_content bg-white rounded-2xl overflow-hidden shadow-lg'>
                <div class='flexmls_connect__slideshow_image_wrapper'>
                    <?php echo $fmc_send_to; ?>
                    <img class='flexmls_connect__slideshow_image'
                        src='<?php echo esc_url($main_photo); ?>'
                        alt='<?php echo esc_attr($img_alt_attr); ?>' />
                         <span class='status_label sold'>Sold </span>
                </div>
                <div class='caption'>
                    <div class='price'><h3><?php echo esc_html($relevant_info_line); ?></h3></div>
                    <div class='address'>
                        <p class='flexmls_connect__listing_address'><?php echo esc_html($address); ?></p>
                    </div>
                    <div class="text-xs text-gray-500">Closed: March 15, 2024</div>
                </div>
                <!-- <span class="rotated_lable">Sold</span> -->
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}

// Shortcode class
class FlexMLS_Shortcodes_SoldProperties {
    public static function shortcode($atts) {
        $atts = shortcode_atts([
            'limit' => 4,
            'source' => 'my',
            'sort' => 'recently_changed', 
        ], $atts);

        global $fmc_api;
        $params = [
            '_limit' => $atts['limit'],
            '_expand' => 'PrimaryPhoto',
            'SortBy' => $atts['sort'],
        ];
      
        $listings = $fmc_api->GetMyListings($params);

        if (!$listings || !is_array($listings)) {
            return "<p>No sold properties found.</p>";
        }
        $output = '<div class="sold-properties featured_listing">';
        foreach ($listings as $li) {
            $listing = $li['StandardFields'];
            $main_photo = $listing['Photos'][0]['Uri640'] ?? '';
            $caption = $listing['Photos'][0]['Caption'] ?? '';
            $address = $listing['UnparsedAddress'] ?? '';
            $price = isset($listing['ListPrice']) ? '$' . number_format($listing['ListPrice']) : '';
        //print_r($li);

            // RENDER THE CARD
            $output .= sold_Properties_Layout::render($listing, [
                'main_photo' => $main_photo,
                'caption' => $caption,
                'address' => $address,
                'price' => $price,
                'mls_id' => $listing['ListingId'] ?? '',
            ]);

        }
        $output .= '</div>';

        return $output;
    }
}

