<?php
/**
 * Custom Post Types
 *
 * @package Elite_Northeast_Realty
 */

// Prevent direct access
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Register Property Post Type
 */
function elite_northeast_realty_register_property_post_type() {
    $labels = array(
        'name'                  => _x( 'Properties', 'Post Type General Name', 'elite-northeast-realty' ),
        'singular_name'         => _x( 'Property', 'Post Type Singular Name', 'elite-northeast-realty' ),
        'menu_name'             => __( 'Properties', 'elite-northeast-realty' ),
        'name_admin_bar'        => __( 'Property', 'elite-northeast-realty' ),
        'archives'              => __( 'Property Archives', 'elite-northeast-realty' ),
        'attributes'            => __( 'Property Attributes', 'elite-northeast-realty' ),
        'parent_item_colon'     => __( 'Parent Property:', 'elite-northeast-realty' ),
        'all_items'             => __( 'All Properties', 'elite-northeast-realty' ),
        'add_new_item'          => __( 'Add New Property', 'elite-northeast-realty' ),
        'add_new'               => __( 'Add New', 'elite-northeast-realty' ),
        'new_item'              => __( 'New Property', 'elite-northeast-realty' ),
        'edit_item'             => __( 'Edit Property', 'elite-northeast-realty' ),
        'update_item'           => __( 'Update Property', 'elite-northeast-realty' ),
        'view_item'             => __( 'View Property', 'elite-northeast-realty' ),
        'view_items'            => __( 'View Properties', 'elite-northeast-realty' ),
        'search_items'          => __( 'Search Property', 'elite-northeast-realty' ),
        'not_found'             => __( 'Not found', 'elite-northeast-realty' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'elite-northeast-realty' ),
        'featured_image'        => __( 'Featured Image', 'elite-northeast-realty' ),
        'set_featured_image'    => __( 'Set featured image', 'elite-northeast-realty' ),
        'remove_featured_image' => __( 'Remove featured image', 'elite-northeast-realty' ),
        'use_featured_image'    => __( 'Use as featured image', 'elite-northeast-realty' ),
        'insert_into_item'      => __( 'Insert into property', 'elite-northeast-realty' ),
        'uploaded_to_this_item' => __( 'Uploaded to this property', 'elite-northeast-realty' ),
        'items_list'            => __( 'Properties list', 'elite-northeast-realty' ),
        'items_list_navigation' => __( 'Properties list navigation', 'elite-northeast-realty' ),
        'filter_items_list'     => __( 'Filter properties list', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'label'                 => __( 'Property', 'elite-northeast-realty' ),
        'description'           => __( 'Real estate property listings', 'elite-northeast-realty' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields' ),
        'taxonomies'            => array( 'property-type', 'property-status', 'property-location' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-building',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'properties', 'with_front' => false ),
    );
    
    register_post_type( 'property', $args );
}
add_action( 'init', 'elite_northeast_realty_register_property_post_type', 0 );

/**
 * Register Property Taxonomies
 */
function elite_northeast_realty_register_property_taxonomies() {
    
    // Property Type Taxonomy
    $labels = array(
        'name'                       => _x( 'Property Types', 'Taxonomy General Name', 'elite-northeast-realty' ),
        'singular_name'              => _x( 'Property Type', 'Taxonomy Singular Name', 'elite-northeast-realty' ),
        'menu_name'                  => __( 'Property Types', 'elite-northeast-realty' ),
        'all_items'                  => __( 'All Property Types', 'elite-northeast-realty' ),
        'parent_item'                => __( 'Parent Property Type', 'elite-northeast-realty' ),
        'parent_item_colon'          => __( 'Parent Property Type:', 'elite-northeast-realty' ),
        'new_item_name'              => __( 'New Property Type Name', 'elite-northeast-realty' ),
        'add_new_item'               => __( 'Add New Property Type', 'elite-northeast-realty' ),
        'edit_item'                  => __( 'Edit Property Type', 'elite-northeast-realty' ),
        'update_item'                => __( 'Update Property Type', 'elite-northeast-realty' ),
        'view_item'                  => __( 'View Property Type', 'elite-northeast-realty' ),
        'separate_items_with_commas' => __( 'Separate property types with commas', 'elite-northeast-realty' ),
        'add_or_remove_items'        => __( 'Add or remove property types', 'elite-northeast-realty' ),
        'choose_from_most_used'      => __( 'Choose from the most used', 'elite-northeast-realty' ),
        'popular_items'              => __( 'Popular Property Types', 'elite-northeast-realty' ),
        'search_items'               => __( 'Search Property Types', 'elite-northeast-realty' ),
        'not_found'                  => __( 'Not Found', 'elite-northeast-realty' ),
        'no_terms'                   => __( 'No property types', 'elite-northeast-realty' ),
        'items_list'                 => __( 'Property Types list', 'elite-northeast-realty' ),
        'items_list_navigation'      => __( 'Property Types list navigation', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
        'rewrite'                    => array( 'slug' => 'property-type', 'with_front' => false ),
    );
    
    register_taxonomy( 'property-type', array( 'property' ), $args );
    
    // Property Status Taxonomy
    $labels = array(
        'name'                       => _x( 'Property Status', 'Taxonomy General Name', 'elite-northeast-realty' ),
        'singular_name'              => _x( 'Property Status', 'Taxonomy Singular Name', 'elite-northeast-realty' ),
        'menu_name'                  => __( 'Property Status', 'elite-northeast-realty' ),
        'all_items'                  => __( 'All Status', 'elite-northeast-realty' ),
        'parent_item'                => __( 'Parent Status', 'elite-northeast-realty' ),
        'parent_item_colon'          => __( 'Parent Status:', 'elite-northeast-realty' ),
        'new_item_name'              => __( 'New Status Name', 'elite-northeast-realty' ),
        'add_new_item'               => __( 'Add New Status', 'elite-northeast-realty' ),
        'edit_item'                  => __( 'Edit Status', 'elite-northeast-realty' ),
        'update_item'                => __( 'Update Status', 'elite-northeast-realty' ),
        'view_item'                  => __( 'View Status', 'elite-northeast-realty' ),
        'separate_items_with_commas' => __( 'Separate status with commas', 'elite-northeast-realty' ),
        'add_or_remove_items'        => __( 'Add or remove status', 'elite-northeast-realty' ),
        'choose_from_most_used'      => __( 'Choose from the most used', 'elite-northeast-realty' ),
        'popular_items'              => __( 'Popular Status', 'elite-northeast-realty' ),
        'search_items'               => __( 'Search Status', 'elite-northeast-realty' ),
        'not_found'                  => __( 'Not Found', 'elite-northeast-realty' ),
        'no_terms'                   => __( 'No status', 'elite-northeast-realty' ),
        'items_list'                 => __( 'Status list', 'elite-northeast-realty' ),
        'items_list_navigation'      => __( 'Status list navigation', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => false,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
        'rewrite'                    => array( 'slug' => 'property-status', 'with_front' => false ),
    );
    
    register_taxonomy( 'property-status', array( 'property' ), $args );
    
    // Property Location Taxonomy
    $labels = array(
        'name'                       => _x( 'Locations', 'Taxonomy General Name', 'elite-northeast-realty' ),
        'singular_name'              => _x( 'Location', 'Taxonomy Singular Name', 'elite-northeast-realty' ),
        'menu_name'                  => __( 'Locations', 'elite-northeast-realty' ),
        'all_items'                  => __( 'All Locations', 'elite-northeast-realty' ),
        'parent_item'                => __( 'Parent Location', 'elite-northeast-realty' ),
        'parent_item_colon'          => __( 'Parent Location:', 'elite-northeast-realty' ),
        'new_item_name'              => __( 'New Location Name', 'elite-northeast-realty' ),
        'add_new_item'               => __( 'Add New Location', 'elite-northeast-realty' ),
        'edit_item'                  => __( 'Edit Location', 'elite-northeast-realty' ),
        'update_item'                => __( 'Update Location', 'elite-northeast-realty' ),
        'view_item'                  => __( 'View Location', 'elite-northeast-realty' ),
        'separate_items_with_commas' => __( 'Separate locations with commas', 'elite-northeast-realty' ),
        'add_or_remove_items'        => __( 'Add or remove locations', 'elite-northeast-realty' ),
        'choose_from_most_used'      => __( 'Choose from the most used', 'elite-northeast-realty' ),
        'popular_items'              => __( 'Popular Locations', 'elite-northeast-realty' ),
        'search_items'               => __( 'Search Locations', 'elite-northeast-realty' ),
        'not_found'                  => __( 'Not Found', 'elite-northeast-realty' ),
        'no_terms'                   => __( 'No locations', 'elite-northeast-realty' ),
        'items_list'                 => __( 'Locations list', 'elite-northeast-realty' ),
        'items_list_navigation'      => __( 'Locations list navigation', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
        'rewrite'                    => array( 'slug' => 'property-location', 'with_front' => false ),
    );
    
    register_taxonomy( 'property-location', array( 'property' ), $args );
}
add_action( 'init', 'elite_northeast_realty_register_property_taxonomies', 0 );

/**
 * Register Agent Post Type
 */
function elite_northeast_realty_register_agent_post_type() {
    $labels = array(
        'name'                  => _x( 'Agents', 'Post Type General Name', 'elite-northeast-realty' ),
        'singular_name'         => _x( 'Agent', 'Post Type Singular Name', 'elite-northeast-realty' ),
        'menu_name'             => __( 'Agents', 'elite-northeast-realty' ),
        'name_admin_bar'        => __( 'Agent', 'elite-northeast-realty' ),
        'archives'              => __( 'Agent Archives', 'elite-northeast-realty' ),
        'attributes'            => __( 'Agent Attributes', 'elite-northeast-realty' ),
        'parent_item_colon'     => __( 'Parent Agent:', 'elite-northeast-realty' ),
        'all_items'             => __( 'All Agents', 'elite-northeast-realty' ),
        'add_new_item'          => __( 'Add New Agent', 'elite-northeast-realty' ),
        'add_new'               => __( 'Add New', 'elite-northeast-realty' ),
        'new_item'              => __( 'New Agent', 'elite-northeast-realty' ),
        'edit_item'             => __( 'Edit Agent', 'elite-northeast-realty' ),
        'update_item'           => __( 'Update Agent', 'elite-northeast-realty' ),
        'view_item'             => __( 'View Agent', 'elite-northeast-realty' ),
        'view_items'            => __( 'View Agents', 'elite-northeast-realty' ),
        'search_items'          => __( 'Search Agent', 'elite-northeast-realty' ),
        'not_found'             => __( 'Not found', 'elite-northeast-realty' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'elite-northeast-realty' ),
        'featured_image'        => __( 'Agent Photo', 'elite-northeast-realty' ),
        'set_featured_image'    => __( 'Set agent photo', 'elite-northeast-realty' ),
        'remove_featured_image' => __( 'Remove agent photo', 'elite-northeast-realty' ),
        'use_featured_image'    => __( 'Use as agent photo', 'elite-northeast-realty' ),
        'insert_into_item'      => __( 'Insert into agent', 'elite-northeast-realty' ),
        'uploaded_to_this_item' => __( 'Uploaded to this agent', 'elite-northeast-realty' ),
        'items_list'            => __( 'Agents list', 'elite-northeast-realty' ),
        'items_list_navigation' => __( 'Agents list navigation', 'elite-northeast-realty' ),
        'filter_items_list'     => __( 'Filter agents list', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'label'                 => __( 'Agent', 'elite-northeast-realty' ),
        'description'           => __( 'Real estate agents and team members', 'elite-northeast-realty' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'excerpt', 'thumbnail', 'custom-fields' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 6,
        'menu_icon'             => 'dashicons-businessperson',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'agents', 'with_front' => false ),
    );
    
    register_post_type( 'agent', $args );
}
add_action( 'init', 'elite_northeast_realty_register_agent_post_type', 0 );

/**
 * Register Community Post Type
 */
function elite_northeast_realty_register_community_post_type() {
    $labels = array(
        'name'                  => _x( 'Communities', 'Post Type General Name', 'elite-northeast-realty' ),
        'singular_name'         => _x( 'Community', 'Post Type Singular Name', 'elite-northeast-realty' ),
        'menu_name'             => __( 'Communities', 'elite-northeast-realty' ),
        'name_admin_bar'        => __( 'Community', 'elite-northeast-realty' ),
        'archives'              => __( 'Community Archives', 'elite-northeast-realty' ),
        'attributes'            => __( 'Community Attributes', 'elite-northeast-realty' ),
        'parent_item_colon'     => __( 'Parent Community:', 'elite-northeast-realty' ),
        'all_items'             => __( 'All Communities', 'elite-northeast-realty' ),
        'add_new_item'          => __( 'Add New Community', 'elite-northeast-realty' ),
        'add_new'               => __( 'Add New', 'elite-northeast-realty' ),
        'new_item'              => __( 'New Community', 'elite-northeast-realty' ),
        'edit_item'             => __( 'Edit Community', 'elite-northeast-realty' ),
        'update_item'           => __( 'Update Community', 'elite-northeast-realty' ),
        'view_item'             => __( 'View Community', 'elite-northeast-realty' ),
        'view_items'            => __( 'View Communities', 'elite-northeast-realty' ),
        'search_items'          => __( 'Search Community', 'elite-northeast-realty' ),
        'not_found'             => __( 'Not found', 'elite-northeast-realty' ),
        'not_found_in_trash'    => __( 'Not found in Trash', 'elite-northeast-realty' ),
        'featured_image'        => __( 'Community Image', 'elite-northeast-realty' ),
        'set_featured_image'    => __( 'Set community image', 'elite-northeast-realty' ),
        'remove_featured_image' => __( 'Remove community image', 'elite-northeast-realty' ),
        'use_featured_image'    => __( 'Use as community image', 'elite-northeast-realty' ),
        'insert_into_item'      => __( 'Insert into community', 'elite-northeast-realty' ),
        'uploaded_to_this_item' => __( 'Uploaded to this community', 'elite-northeast-realty' ),
        'items_list'            => __( 'Communities list', 'elite-northeast-realty' ),
        'items_list_navigation' => __( 'Communities list navigation', 'elite-northeast-realty' ),
        'filter_items_list'     => __( 'Filter communities list', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'label'                 => __( 'Community', 'elite-northeast-realty' ),
        'description'           => __( 'Neighborhoods and communities', 'elite-northeast-realty' ),
        'labels'                => $labels,
        'supports'              => array( 'title', 'editor', 'excerpt', 'thumbnail', 'custom-fields' ),
        'taxonomies'            => array( 'state' ),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 7,
        'menu_icon'             => 'dashicons-location-alt',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'post',
        'show_in_rest'          => true,
        'rewrite'               => array( 'slug' => 'communities', 'with_front' => false ),
    );
    
    register_post_type( 'community', $args );
}
add_action( 'init', 'elite_northeast_realty_register_community_post_type', 0 );

/**
 * Register State Taxonomy for Communities
 */
function elite_northeast_realty_register_state_taxonomy() {
    $labels = array(
        'name'                       => _x( 'States', 'Taxonomy General Name', 'elite-northeast-realty' ),
        'singular_name'              => _x( 'State', 'Taxonomy Singular Name', 'elite-northeast-realty' ),
        'menu_name'                  => __( 'States', 'elite-northeast-realty' ),
        'all_items'                  => __( 'All States', 'elite-northeast-realty' ),
        'parent_item'                => __( 'Parent State', 'elite-northeast-realty' ),
        'parent_item_colon'          => __( 'Parent State:', 'elite-northeast-realty' ),
        'new_item_name'              => __( 'New State Name', 'elite-northeast-realty' ),
        'add_new_item'               => __( 'Add New State', 'elite-northeast-realty' ),
        'edit_item'                  => __( 'Edit State', 'elite-northeast-realty' ),
        'update_item'                => __( 'Update State', 'elite-northeast-realty' ),
        'view_item'                  => __( 'View State', 'elite-northeast-realty' ),
        'separate_items_with_commas' => __( 'Separate states with commas', 'elite-northeast-realty' ),
        'add_or_remove_items'        => __( 'Add or remove states', 'elite-northeast-realty' ),
        'choose_from_most_used'      => __( 'Choose from the most used', 'elite-northeast-realty' ),
        'popular_items'              => __( 'Popular States', 'elite-northeast-realty' ),
        'search_items'               => __( 'Search States', 'elite-northeast-realty' ),
        'not_found'                  => __( 'Not Found', 'elite-northeast-realty' ),
        'no_terms'                   => __( 'No states', 'elite-northeast-realty' ),
        'items_list'                 => __( 'States list', 'elite-northeast-realty' ),
        'items_list_navigation'      => __( 'States list navigation', 'elite-northeast-realty' ),
    );
    
    $args = array(
        'labels'                     => $labels,
        'hierarchical'               => true,
        'public'                     => true,
        'show_ui'                    => true,
        'show_admin_column'          => true,
        'show_in_nav_menus'          => true,
        'show_tagcloud'              => true,
        'show_in_rest'               => true,
        'rewrite'                    => array( 'slug' => 'state', 'with_front' => false ),
    );
    
    register_taxonomy( 'state', array( 'community' ), $args );
}
add_action( 'init', 'elite_northeast_realty_register_state_taxonomy', 0 );

/**
 * Flush rewrite rules on theme activation
 */
function elite_northeast_realty_rewrite_flush() {
    elite_northeast_realty_register_property_post_type();
    elite_northeast_realty_register_property_taxonomies();
    elite_northeast_realty_register_agent_post_type();
    elite_northeast_realty_register_community_post_type();
    elite_northeast_realty_register_state_taxonomy();
    flush_rewrite_rules();
}
add_action( 'after_switch_theme', 'elite_northeast_realty_rewrite_flush' );