# Single Agent Template Documentation

## Overview
The `single-agent.php` template displays individual agent profiles with their complete information, listings, testimonials, and contact capabilities.

## Template File
- **Location**: `/elite-realty-theme/single-agent.php`
- **Post Type**: `agent`

## Required Assets

### CSS
- `/assets/css/agent-single.css` - Agent-specific styles

### JavaScript
- `/assets/js/agent-single.js` - Interactive features (testimonial slider, forms, etc.)

### Images
- `/assets/images/agent-placeholder.svg` - Placeholder for agents without photos
- `/assets/images/agent-hero-bg.jpg` - Hero section background (optional)

## ACF Field Groups

### Agent Information Fields
```php
// Basic Information
'phone' => Text field
'email' => Email field
'position' => Text field (e.g., "Senior Luxury Properties Specialist")
'years_experience' => Number field

// Social Media
'facebook_url' => URL field
'instagram_url' => URL field
'linkedin_url' => URL field
'twitter_url' => URL field

// About Section
'about_description' => Textarea/WYSIWYG field
'education' => Textarea field
'languages' => Textarea field
'philosophy_quote' => Textarea field

// Statistics
'total_sales' => Text field (e.g., "$150M+")
'happy_clients' => Text field (e.g., "200+")

// Office Information
'office_location' => Text field (e.g., "Elite Northeast Realty")
'office_address' => Textarea field
'working_hours' => Textarea field
```

### Repeater Fields

#### Expertise Areas
Field name: `expertise_areas`
Sub-fields:
- `icon` - Text field (Remix Icon class, e.g., "ri-home-4-line")
- `title` - Text field
- `description` - Textarea field

#### Testimonials
Field name: `testimonials`
Sub-fields:
- `client_name` - Text field
- `client_title` - Text field
- `client_photo` - Image field
- `testimonial_text` - Textarea field
- `transaction_details` - Text field (e.g., "Purchased: $4.2M Waterfront Estate • Closed: March 2024")

#### Recent Transactions
Field name: `recent_transactions`
Sub-fields:
- `property_image` - Image field
- `sale_price` - Number field
- `location` - Text field
- `closing_date` - Text field

## Property Relationship

The template queries properties where the agent is the listing agent:

```php
'meta_query' => array(
    array(
        'key' => 'listing_agent',
        'value' => get_the_ID(),
        'compare' => '='
    )
)
```

This requires a custom field on the property post type that references the agent.

## Contact Form Integration

The template supports two form methods:

1. **Contact Form 7** - If installed, use shortcode with ID `agent-contact-form`
2. **Custom Form Handler** - Built-in fallback with AJAX submission

### Form Fields
- First Name (required)
- Last Name (required)
- Email (required)
- Phone (optional)
- Message (required)

### Form Handlers
- AJAX: `wp_ajax_handle_agent_contact`
- Non-AJAX: `admin_post_handle_agent_contact`

## Features

### Interactive Elements
1. **Testimonial Slider**
   - Auto-rotating testimonials
   - Touch/swipe support on mobile
   - Dot navigation

2. **Smooth Scroll**
   - "Schedule Consultation" buttons scroll to contact form
   - Anchor link support

3. **Lazy Loading**
   - Images load as they enter viewport
   - Improves page performance

### Responsive Design
- Mobile-optimized layout
- Touch-friendly interactions
- Responsive image sizes

## Customization Notes

### Hero Background
To use a custom hero background image instead of the AI-generated one:
1. Upload image to `/assets/images/agent-hero-bg.jpg`
2. Or modify the CSS to use a different image

### Color Scheme
Uses theme's primary color (`#2563eb`) defined in Tailwind config.

### Contact Form Styling
Contact Form 7 styles are included in the CSS file. Modify as needed for your form plugin.

## Required Plugins

### Recommended
- **Advanced Custom Fields (ACF)** - For custom fields
- **Contact Form 7** - For contact form (optional)

### ACF Field Group Export
Import the following field group for the Agent post type:

```json
{
  "key": "group_agent_fields",
  "title": "Agent Information",
  "fields": [
    // Field definitions here
  ],
  "location": [
    [
      {
        "param": "post_type",
        "operator": "==",
        "value": "agent"
      }
    ]
  ]
}
```

## Usage Instructions

1. Create or edit an Agent post
2. Fill in all custom fields
3. Set featured image for agent photo
4. Add expertise areas, testimonials, and recent transactions
5. Ensure properties have the agent selected in their `listing_agent` field
6. The template will automatically display all information

## Troubleshooting

### Missing Styles/Scripts
Ensure the enqueue conditions in `functions.php` are working:
```php
if ( is_singular( 'agent' ) ) {
    // Enqueue agent assets
}
```

### Form Not Submitting
1. Check JavaScript console for errors
2. Verify nonce is being generated
3. Ensure AJAX URL is correct
4. Check email configuration

### Images Not Loading
1. Verify image field returns proper array/URL
2. Check placeholder image path
3. Ensure proper image sizes are defined

## Security Considerations

1. All form inputs are sanitized
2. Nonces protect form submissions
3. Email addresses are validated
4. User capabilities are checked where appropriate