# About Page Template Documentation

## Overview
The About page template (`page-about.php`) is a custom WordPress page template designed for the Elite Northeast Realty theme. It provides a professional layout for displaying company information, service areas, mission & values, and a call-to-action section.

## Template Features

### 1. Breadcrumb Navigation
- Displays hierarchical navigation (Home > About Us)
- Custom styling with arrow separators

### 2. Hero Section
- Page title (uses WordPress page title)
- Optional subtitle (ACF field: `page_subtitle`)
- Fallback content when ACF is not available

### 3. Our Story Section
- Customizable title (ACF field: `our_story_title`)
- Rich text content area (ACF field: `our_story_content`)
- Falls back to WordPress page content if ACF fields are not set

### 4. Service Areas Section
- Interactive map display
- Customizable title and subtitle
- Service area map image (ACF field: `service_area_map`)
- Market knowledge section with feature list
- Legend showing primary markets and extended coverage

### 5. Mission & Values Section
- Customizable title (ACF field: `mission_values_title`)
- Rich text content area (ACF field: `mission_values_content`)
- Professional card-based layout

### 6. Call-to-Action Section
- Customizable heading and description
- Two action buttons with customizable text and links
- Featured image with shadow effect
- Success metrics card overlay

## ACF Fields Structure

### Page Settings
- `page_subtitle` (Text) - Subtitle displayed under the main page title

### Our Story Section
- `our_story_title` (Text) - Section title
- `our_story_content` (WYSIWYG) - Rich text content

### Service Areas Section
- `service_areas_title` (Text) - Section title
- `service_areas_subtitle` (Text) - Section subtitle
- `service_area_map` (Image) - Service area map image
- `market_knowledge_title` (Text) - Market knowledge heading
- `market_knowledge_description` (Textarea) - Market knowledge description
- `service_features` (Repeater) - Service features list
  - `feature_text` (Text) - Individual feature item

### Mission & Values Section
- `mission_values_title` (Text) - Section title
- `mission_values_content` (WYSIWYG) - Rich text content

### Call-to-Action Section
- `cta_title` (Text) - CTA heading
- `cta_description` (Textarea) - CTA description
- `cta_primary_button_text` (Text) - Primary button text
- `cta_primary_button_link` (URL) - Primary button link
- `cta_secondary_button_text` (Text) - Secondary button text
- `cta_secondary_button_link` (URL) - Secondary button link
- `cta_image` (Image) - Featured image
- `success_metric_number` (Text) - Success metric number
- `success_metric_text` (Textarea) - Success metric description

## Usage Instructions

### 1. Create a New Page
1. In WordPress admin, go to Pages > Add New
2. Enter your page title (e.g., "About Elite Northeast Realty")
3. In the Page Attributes box, select "About Us" from the Template dropdown
4. Save/Publish the page

### 2. Without ACF
The template works out of the box without ACF installed:
- Add content to the main WordPress editor for the "Our Story" section
- Default placeholder images and text will be displayed
- All sections will use fallback content

### 3. With ACF Installed
1. Install and activate Advanced Custom Fields plugin
2. Create a field group for the About page template
3. Add the fields listed in the ACF Fields Structure section above
4. Assign the field group to pages using the "About Us" template
5. Fill in the custom fields when editing the page

## Styling

### CSS Files
- `custom.css` - General theme styles
- `about-page.css` - Page-specific styles including:
  - County map hover effects
  - Breadcrumb styling
  - Section animations
  - Responsive adjustments

### JavaScript
The page uses the theme's navigation.js for:
- Smooth scrolling
- Back to top button
- Mobile menu functionality

## Placeholder Images
The theme includes SVG placeholder images:
- `service-area-map-placeholder.svg` - Default service area map
- `consultation-placeholder.svg` - Default consultation image

## Responsive Design
The template is fully responsive with:
- Mobile-optimized navigation
- Stacked layouts on smaller screens
- Touch-friendly interactive elements
- Optimized image sizes

## Customization Tips

### Changing Colors
Edit the Tailwind configuration in `functions.php`:
```php
colors: {
    primary: "#2563eb",    // Blue
    secondary: "#64748b"   // Gray
}
```

### Adding New Sections
1. Add the HTML structure to `page-about.php`
2. Create corresponding ACF fields
3. Add styles to `about-page.css`
4. Use conditional checks for ACF: `function_exists('get_field')`

### Image Optimization
- Use WebP format for better performance
- Recommended sizes:
  - Service area map: 800x600px
  - CTA image: 800x600px
  - Keep file sizes under 200KB

## Troubleshooting

### ACF Fields Not Showing
1. Ensure ACF plugin is activated
2. Check field group location rules
3. Verify field names match the template

### Styling Issues
1. Clear browser cache
2. Check if `about-page.css` is being loaded
3. Verify Tailwind CSS is properly configured

### Images Not Displaying
1. Check file permissions in the uploads folder
2. Verify image paths are correct
3. Ensure placeholder images exist in the theme