/**
 * Front Page JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    // Navbar scroll effect
    const navbar = document.querySelector('.navbar');
    const backToTop = document.getElementById('backToTop');
    
    window.addEventListener('scroll', function() {
        if (window.scrollY > 100) {
            navbar.classList.add('scrolled');
            backToTop.classList.add('visible');
        } else {
            navbar.classList.remove('scrolled');
            backToTop.classList.remove('visible');
        }
    });
    
    // Back to top button
    backToTop.addEventListener('click', function() {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
    
    // Property slider
    const slider = document.getElementById('propertySlider');
    const prevBtn = document.getElementById('prevBtn');
    const nextBtn = document.getElementById('nextBtn');
    const dots = document.getElementById('sliderDots').getElementsByTagName('button');
    
    let currentSlide = 0;
    const totalSlides = Math.max(0, Math.floor(slider.children.length / 3) - 1); // Adjust for responsive
    
    function updateSliderControls() {
        if (currentSlide === 0) {
            prevBtn.classList.add('opacity-50', 'cursor-not-allowed');
        } else {
            prevBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        }
        
        if (currentSlide === totalSlides) {
            nextBtn.classList.add('opacity-50', 'cursor-not-allowed');
        } else {
            nextBtn.classList.remove('opacity-50', 'cursor-not-allowed');
        }
    }
    
    function updateDots() {
        Array.from(dots).forEach((dot, index) => {
            dot.classList.toggle('bg-primary', index === currentSlide);
            dot.classList.toggle('bg-gray-300', index !== currentSlide);
        });
    }
    
    function smoothScroll(offset) {
        slider.style.transition = 'transform 0.5s ease-in-out';
        slider.style.transform = `translateX(${offset}%)`;
        
        setTimeout(() => {
            slider.style.transition = '';
        }, 500);
    }
    
    function updateSlider() {
        const offset = currentSlide * -100;
        smoothScroll(offset);
        updateDots();
        updateSliderControls();
    }
    
    // Previous button
    prevBtn.addEventListener('click', () => {
        if (currentSlide > 0) {
            currentSlide--;
            updateSlider();
        }
    });
    
    // Next button
    nextBtn.addEventListener('click', () => {
        if (currentSlide < totalSlides) {
            currentSlide++;
            updateSlider();
        }
    });
    
    // Dot navigation
    Array.from(dots).forEach((dot, index) => {
        dot.addEventListener('click', () => {
            currentSlide = index;
            updateSlider();
        });
    });
    
    // Touch support for mobile
    let touchStartX = 0;
    let touchEndX = 0;
    
    slider.addEventListener('touchstart', (e) => {
        touchStartX = e.touches[0].clientX;
    }, false);
    
    slider.addEventListener('touchmove', (e) => {
        touchEndX = e.touches[0].clientX;
        const diffX = touchStartX - touchEndX;
        const sensitivity = 50;
        
        if (Math.abs(diffX) > sensitivity) {
            if (diffX > 0 && currentSlide < totalSlides) {
                currentSlide++;
                updateSlider();
            } else if (diffX < 0 && currentSlide > 0) {
                currentSlide--;
                updateSlider();
            }
            touchStartX = touchEndX;
        }
    }, false);
    
    // Initialize slider
    updateSlider();
});