<?php
namespace FlexMLS\Shortcodes;
// Layout class
class Properties_Layout {
    public static function render($listing, $args = []) {
        $main_photo = $args['main_photo'] ?? '';
        $caption = $args['caption'] ?? '';
        $address = $args['address'] ?? '';
        $price = $args['price'] ?? '';
        $link = $args['link'] ?? '#';
        $mls_id = $args['mls_id'] ?? '';
        $extra_title_line = $args['extra_title_line'] ?? '';
        $img_alt_attr = $args['img_alt_attr'] ?? $caption;
        $relevant_info_line = $args['relevant_info_line'] ?? $price;
        $status = $args['status'] ?? '';
        $fmc_send_to = $args['fmc_send_to'] ?? '';
        $description = $args['description'] ?? '';
        $listofficename = $args['listofficename'] ?? '';

        ob_start();
        ?>
        <div class='flexmls_connect__listing test property-card flex-shrink-0 w-full md:w-1/3 px-3'
             title='<?php echo esc_attr("{$address} | MLS #: {$mls_id} | {$price}{$extra_title_line}"); ?>'
             link='<?php echo esc_url($link); ?>'>
            <div class='flexmls_content bg-white rounded-2xl overflow-hidden shadow-lg'>
                <div class='flexmls_connect__slideshow_image_wrapper'>
                    <?php echo $fmc_send_to; ?>
                    <img class='flexmls_connect__slideshow_image' src='<?php echo esc_url($main_photo); ?>' alt='<?php echo esc_attr($img_alt_attr); ?>' />
                    <?php if (!empty($status)) : ?>
                        <span class='status_label'>
                            <?php echo esc_html($status); ?>
                    </span>  
                    <?php endif; ?>
                </div>
                <div class='caption'>
                    <div class='address'>
                        <?php if (strpos($address, '*') === false): ?>
                            <p class="flexmls_connect__listing_address"><?php echo esc_html($address); ?></p>
                        <?php endif; ?> 
                    </div>
                    <?php if (!empty($description)) : ?>
                        <div class="description">
                        <p><?php echo esc_html( mb_substr($description, 0, 100) ) . '...'; ?></p>
                        </div>
                     <?php endif; ?>
                    <div class='office_location_price'>
                        <?php if (!empty($listofficename)) : ?>
                        <div class="office_name">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <path d="M12 2C8.686 2 6 4.686 6 8c0 4.29 5.25 10.11 5.52 10.4a1 1 0 0 0 1.46 0C12.75 18.11 18 12.29 18 8c0-3.314-2.686-6-6-6zm0 8.5A2.5 2.5 0 1 1 12 5a2.5 2.5 0 0 1 0 5.5z"
                                    fill="#6B7280"/>
                            </svg>
                            <span class="flexmls_connect__listing_office_name"><?php echo esc_html($listofficename); ?></span>
                        </div>
                        <?php endif; ?>
                        <div class='price'>
                            <p>price</p>
                            <h3><?php echo esc_html($relevant_info_line); ?></h3>
                        </div>
                    </div>
                    <div class='w-4 h-4 flex items-center justify-center button_link'>
                        <a class='flexmls_connect__virtual_tour_link property_grid' href='<?php echo esc_url($link); ?>' target='_blank'>
                            <span>View Property </span>
                            <svg width="18" height="16" viewBox="0 0 18 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M12.0416 7.33343L8.45496 3.7601L9.40163 2.81343L14.5883 8.0001L9.40163 13.1868L8.45496 12.2401L12.0416 8.66677H3.92163V7.33343H12.0416Z" fill="white"/>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }
}

// Shortcode class
class FlexMLS_Shortcodes_Properties  {
    public static function shortcode($atts) {
        $atts = shortcode_atts([
            'limit' => 15,
            'source' => 'location',
            'property_type' => 'D',
            'sort' => 'recently_changed', 
            'idx_link' => '1r0pxuut5lc4',
        ], $atts);

        global $fmc_api;
        $params = [
            '_limit' => $atts['limit'],
            '_expand' => 'PrimaryPhoto',
            'SortBy' => $atts['sort'],
            'IdxLink' => $atts['idx_link'],
        ];

        if (!empty($atts['property_type'])) {
            $params['_filter'] = "PropertyType Eq '" . esc_attr($atts['property_type']) . "'";
        }

        $listings = $fmc_api->GetListings($params);
        if (!$listings || !is_array($listings)) {
            return '<p>The widget is currently unavailable. Please refresh the page or try again later.</p>';
        }
        $output = '<div class="properties-grid featured_listing">';
        foreach ($listings as $li) { 
            $listing = $li['StandardFields'];
            $main_photo = $listing['Photos'][0]['Uri640'] ?? '';
            $caption = $listing['Photos'][0]['Caption'] ?? '';
            $address = $listing['UnparsedAddress'] ?? '';
            $price = isset($listing['ListPrice']) ? '$' . number_format($listing['ListPrice']) : '';
            $destination = 'local';
            $this_link = null;

            $this_target = '';
            if (!empty($listing)) {
                $slug = implode('-', array_map('urlencode', [
                    $listing['StreetAddress'] ?? '',
                    $listing['City'] ?? '',
                    $listing['StateOrProvince'] ?? '',
                    $listing['PostalCode'] ?? ''
                ]));
				$slug = str_replace([' ', ','], ['-', ''], $address);
                $mls_id = $listing['OriginatingSystemListingId'];
                $property_type = $listing['PropertyType'] ?? '';
                
                $this_link = "/buttonre/properties/{$slug}-mls_{$mls_id}/?PropertyType={$property_type}";
            }

            $link = !empty($this_link) ? $this_link : '#';
            // ICONS
            $beds_icon = '<svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13.8374 6.41144V11.665H12.6699V9.91384H3.33016V11.665H2.16269V2.32531H3.33016V8.16264H8.00002V4.07651H11.5024C11.9227 4.07651 12.3119 4.18158 12.6699 4.39172C13.0279 4.60187 13.312 4.88595 13.5221 5.24397C13.7323 5.602 13.8374 5.99115 13.8374 6.41144ZM12.6699 8.16264V6.41144C12.6699 6.2013 12.6174 6.00672 12.5123 5.82771C12.4072 5.6487 12.2652 5.50665 12.0862 5.40158C11.9071 5.29651 11.7126 5.24397 11.5024 5.24397H9.16749V8.16264H12.6699ZM5.66509 6.41144C5.82853 6.41144 5.96668 6.35501 6.07954 6.24216C6.19239 6.1293 6.24882 5.99115 6.24882 5.82771C6.24882 5.66426 6.19239 5.52611 6.07954 5.41326C5.96668 5.3004 5.82853 5.24397 5.66509 5.24397C5.50164 5.24397 5.36349 5.3004 5.25064 5.41326C5.13778 5.52611 5.08136 5.66426 5.08136 5.82771C5.08136 5.99115 5.13778 6.1293 5.25064 6.24216C5.36349 6.35501 5.50164 6.41144 5.66509 6.41144ZM5.66509 7.57891C5.34598 7.57891 5.05217 7.50108 4.78365 7.34541C4.51513 7.18975 4.30304 6.97766 4.14738 6.70914C3.99172 6.44063 3.91389 6.14681 3.91389 5.82771C3.91389 5.5086 3.99172 5.21479 4.14738 4.94627C4.30304 4.67775 4.51513 4.46566 4.78365 4.31C5.05217 4.15434 5.34598 4.07651 5.66509 4.07651C5.9842 4.07651 6.27801 4.15434 6.54653 4.31C6.81504 4.46566 7.02713 4.67775 7.18279 4.94627C7.33846 5.21479 7.41629 5.5086 7.41629 5.82771C7.41629 6.14681 7.33846 6.44063 7.18279 6.70914C7.02713 6.97766 6.81504 7.18975 6.54653 7.34541C6.27801 7.50108 5.9842 7.57891 5.66509 7.57891Z" fill="#6B7280"/>
                        </svg>';
            $baths_icon = '<svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.95502 2.30999L5.07335 5.20332C4.54446 5.72443 4.18668 6.33888 4.00002 7.04665C3.82113 7.73888 3.82113 8.4311 4.00002 9.12332C4.18668 9.8311 4.54252 10.4475 5.06752 10.9725C5.59252 11.4975 6.20891 11.8533 6.91668 12.04C7.60891 12.2189 8.30113 12.2189 8.99335 12.04C9.70113 11.8533 10.3175 11.4975 10.8425 10.9725C11.3675 10.4475 11.7234 9.8311 11.91 9.12332C12.0889 8.4311 12.0889 7.73888 11.91 7.04665C11.7234 6.33888 11.3656 5.72443 10.8367 5.20332L7.95502 2.30999ZM7.95502 0.664987L11.665 4.37499C12.3417 5.04388 12.7967 5.83721 13.03 6.75499C13.2634 7.64165 13.2634 8.52832 13.03 9.41499C12.7967 10.3328 12.3436 11.128 11.6709 11.8008C10.9981 12.4736 10.2028 12.9305 9.28502 13.1717C8.39835 13.3972 7.51168 13.3972 6.62502 13.1717C5.70724 12.9305 4.91196 12.4736 4.23918 11.8008C3.56641 11.128 3.11335 10.3328 2.88002 9.41499C2.64668 8.52832 2.64668 7.64165 2.88002 6.75499C3.11335 5.83721 3.56835 5.04388 4.24502 4.37499L7.95502 0.664987Z" fill="#6B7280"/>
                          </svg>';
            $sqft_icon = '<svg width="16" height="14" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13.015 1.75C13.1783 1.75 13.3164 1.80639 13.4291 1.91917C13.5419 2.03194 13.5983 2.17 13.5983 2.33333V11.6667C13.5983 11.83 13.5419 11.9681 13.4291 12.0808C13.3164 12.1936 13.1783 12.25 13.015 12.25H2.51497C2.35164 12.25 2.21359 12.1936 2.10081 12.0808C1.98803 11.9681 1.93164 11.83 1.93164 11.6667V2.33333C1.93164 2.17 1.98803 2.03194 2.10081 1.91917C2.21359 1.80639 2.35164 1.75 2.51497 1.75H13.015ZM12.4316 2.91667H3.09831V11.0833H12.4316V2.91667ZM8.34831 9.91667V8.75H10.0983V7H11.265V9.91667H8.34831ZM7.18164 4.08333V5.25H5.43164V7H4.26497V4.08333H7.18164Z" fill="#6B7280"/>
                        </svg>';
            // BUILD THE TALL LINE
            $show_additional_field_line = [];
           if (!empty($listing['BedsTotal']) && is_numeric($listing['BedsTotal'])) {
                $show_additional_field_line[] = "<span class='beds'>{$beds_icon}{$listing['BedsTotal']} beds</span>";
            }

            // Only show baths if value is numeric and not masked
            if (!empty($listing['BathsTotal']) && is_numeric($listing['BathsTotal'])) {
                $show_additional_field_line[] = "<span class='baths'>{$baths_icon}{$listing['BathsTotal']} baths</span>";
            }

            // Only show sqft if value is numeric and not masked
            if (!empty($listing['BuildingAreaTotal']) && is_numeric($listing['BuildingAreaTotal'])) {
                $show_additional_field_line[] = "<span class='sqft'>{$sqft_icon}" . number_format((float)$listing['BuildingAreaTotal']) . " sqft</span>";
            }

            $tall_line = '';
            if ($show_additional_field_line) {
                $tall_line = "<div class='dark'>" . implode(" ", $show_additional_field_line) . "</div>";
            }

            // RENDER THE CARD
            $output .= Properties_Layout::render($listing, [
                'main_photo' => $main_photo,
                'caption' => $caption,
                'address' => $address,
                'price' => $price,
                'link' => $link,
                'mls_id' => $listing['ListingId'] ?? '',
                'tall_line' => $tall_line,
                'description' => $listing['PublicRemarks'] ?? '',
                'listofficename' => $listing['ListOfficeName'] ?? '',
                'status' => $listing['MlsStatus'] ?? '',
            ]);

        }
        $output .= '</div>';

        return $output;
    }
}

// Register the shortcode
add_shortcode('buttonre_properties', ['FlexMLS_Shortcodes_FeaturedProperties', 'shortcode']);