document.addEventListener("DOMContentLoaded", function () {

    window.addEventListener("scroll", function () {
        const header = document.querySelector(".main_header_section");
        if (!header) return;

        if (window.scrollY > 80) {
            header.classList.add('fixed_header');
        } else {
            header.classList.remove('fixed_header');
        }
    });
	
	jQuery('.testimonials_slider').slick({
        infinite: true,
        slidesToShow: 1,
        slidesToScroll: 1,
        arrows: false,
        dots: true,
        adaptiveHeight: true,
//         prevArrow: "<button class='custom_previous'> <svg width='18' height='16' viewBox='0 0 18 16' fill='none' xmlns='http://www.w3.org/2000/svg'><path d='M6.20835 7.33331H14.3283V8.66665H6.20835L9.79502 12.24L8.84835 13.1866L3.66168 7.99998L8.84835 2.81331L9.79502 3.75998L6.20835 7.33331Z' fill='#4B5563'/></svg></button>",
//         nextArrow: "<button class='custom_next'><svg width='18' height='16' viewBox='0 0 18 16' fill='none' xmlns='http://www.w3.org/2000/svg'><path d='M11.7817 7.33331L8.19508 3.75998L9.14174 2.81331L14.3284 7.99998L9.14174 13.1866L8.19508 12.24L11.7817 8.66665H3.66174V7.33331H11.7817Z' fill='#4B5563'/></svg></button>",
        responsive: [   
            {
                breakpoint: 576,
                settings: {
                    slidesToShow: 1,
                    slidesToScroll: 1,
                    adaptiveHeight: true
                }
            }
        ]
    });
    
});

jQuery(document).ready(function($) {
    const texts = [
      "Discover luxury properties in New England's most prestigious neighborhoods",
      "Your Dream Home Won't Find Itself",
      "From House Hunting to House Haunting",
      "Where 'Just Looking' Becomes 'Just Bought'",
      "Find Your Sanctuary (Pants Optional)",
      "Turn Your Pinterest Board Into an Address",
      "Less Renting Drama, More House Karma",
      "Your Future Neighbors Are Waiting",
      "Stop Making Your Landlord Rich",
      "Find Your Forever Netflix & Chill Spot",
      "Home is Where You Can Sing in the Shower",
      "Your Next Chapter Needs the Right Setting",
      "From Apartment Therapy to House Therapy",
      "Where 'Location, Location, Location' Meets Reality"
    ];
 
    const $heroText = $("#hero-text p.elementor-heading-title");
 
    if ($heroText.length) {
      const randomIndex = Math.floor(Math.random() * texts.length);
      $heroText.text(texts[randomIndex]);
    }
});

document.addEventListener("DOMContentLoaded", function () {
    const widget = document.querySelector("fello-elements-search-widget");

    if (widget && widget.shadowRoot) {
        const style = document.createElement("style");
        style.textContent = `
            form {
                border-radius: 10px !important;
                overflow: hidden;
            }
			input::placeholder {
				font-size: 18px;
				text-transform: capitalize !important;
			}
            button {
                border-radius: 10px !important;
				font-weight: 300;
            }
        `;
        widget.shadowRoot.appendChild(style);
    }
});

