<?php
/**
 * The template for displaying search results pages
 *
 * @package Elite_Northeast_Realty
 */

get_header();
?>

<main id="primary" class="site-main">
    <!-- Search Results Header -->
    <section class="bg-navy-900 text-white py-16">
        <div class="container mx-auto px-4">
            <h1 class="text-4xl font-bold mb-4">
                <?php
                /* translators: %s: search query. */
                printf( esc_html__( 'Search Results for: %s', 'elite-northeast-realty' ), '<span class="text-gold-500">' . get_search_query() . '</span>' );
                ?>
            </h1>
            <div class="flex items-center text-gray-300">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="hover:text-gold-500 transition duration-300">Home</a>
                <span class="mx-2">/</span>
                <span>Search Results</span>
            </div>
        </div>
    </section>

    <!-- Search Form -->
    <section class="py-8 bg-gray-100">
        <div class="container mx-auto px-4">
            <div class="max-w-2xl mx-auto">
                <form role="search" method="get" action="<?php echo esc_url( home_url( '/' ) ); ?>" class="flex gap-2">
                    <input type="search" 
                           class="flex-1 px-4 py-3 border border-gray-300 rounded-md focus:ring-2 focus:ring-gold-500 focus:border-gold-500" 
                           placeholder="<?php echo esc_attr_x( 'Search again...', 'placeholder', 'elite-northeast-realty' ); ?>" 
                           value="<?php echo get_search_query(); ?>" 
                           name="s" />
                    <button type="submit" class="bg-gold-600 text-white px-6 py-3 rounded-md hover:bg-gold-700 transition duration-300">
                        <?php echo esc_html_x( 'Search', 'submit button', 'elite-northeast-realty' ); ?>
                    </button>
                </form>
            </div>
        </div>
    </section>

    <!-- Search Results -->
    <section class="py-16">
        <div class="container mx-auto px-4">
            <?php if ( have_posts() ) : ?>
                
                <?php
                // Group results by post type
                $results_by_type = array();
                while ( have_posts() ) {
                    the_post();
                    $post_type = get_post_type();
                    if ( ! isset( $results_by_type[ $post_type ] ) ) {
                        $results_by_type[ $post_type ] = array();
                    }
                    $results_by_type[ $post_type ][] = $post;
                }
                
                // Display results grouped by type
                foreach ( $results_by_type as $post_type => $posts ) :
                    $post_type_obj = get_post_type_object( $post_type );
                    ?>
                    <div class="mb-12">
                        <h2 class="text-2xl font-bold text-gray-900 mb-6 pb-2 border-b-2 border-gold-500">
                            <?php echo esc_html( $post_type_obj->labels->name ); ?> 
                            <span class="text-gray-500 text-lg font-normal">(<?php echo count( $posts ); ?> <?php echo _n( 'result', 'results', count( $posts ), 'elite-northeast-realty' ); ?>)</span>
                        </h2>
                        
                        <?php if ( $post_type === 'property' ) : ?>
                            <!-- Property Results Grid -->
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                                <?php foreach ( $posts as $post ) : setup_postdata( $post ); ?>
                                    <article class="bg-white rounded-lg shadow-md overflow-hidden hover:shadow-lg transition duration-300">
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <a href="<?php the_permalink(); ?>" class="block aspect-w-16 aspect-h-12 overflow-hidden">
                                                <?php the_post_thumbnail( 'medium_large', array( 'class' => 'w-full h-full object-cover hover:scale-105 transition duration-300' ) ); ?>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <div class="p-6">
                                            <h3 class="text-xl font-semibold mb-2">
                                                <a href="<?php the_permalink(); ?>" class="text-gray-900 hover:text-gold-600 transition duration-300">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h3>
                                            
                                            <?php
                                            $price = get_post_meta( get_the_ID(), '_property_price', true );
                                            if ( $price ) : ?>
                                                <p class="text-2xl font-bold text-gold-600 mb-2"><?php echo esc_html( elite_format_price( $price ) ); ?></p>
                                            <?php endif; ?>
                                            
                                            <div class="text-gray-600 mb-4">
                                                <?php echo wp_trim_words( get_the_excerpt(), 20 ); ?>
                                            </div>
                                            
                                            <a href="<?php the_permalink(); ?>" class="inline-flex items-center text-gold-600 hover:text-gold-700 font-semibold">
                                                View Details
                                                <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                                </svg>
                                            </a>
                                        </div>
                                    </article>
                                <?php endforeach; ?>
                            </div>
                            
                        <?php elseif ( $post_type === 'agent' ) : ?>
                            <!-- Agent Results Grid -->
                            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                                <?php foreach ( $posts as $post ) : setup_postdata( $post ); ?>
                                    <article class="bg-white rounded-lg shadow-md overflow-hidden text-center hover:shadow-lg transition duration-300">
                                        <?php if ( has_post_thumbnail() ) : ?>
                                            <a href="<?php the_permalink(); ?>" class="block">
                                                <?php the_post_thumbnail( 'medium', array( 'class' => 'w-full h-48 object-cover' ) ); ?>
                                            </a>
                                        <?php endif; ?>
                                        
                                        <div class="p-4">
                                            <h3 class="text-lg font-semibold mb-1">
                                                <a href="<?php the_permalink(); ?>" class="text-gray-900 hover:text-gold-600 transition duration-300">
                                                    <?php the_title(); ?>
                                                </a>
                                            </h3>
                                            
                                            <?php
                                            $position = get_post_meta( get_the_ID(), '_agent_position', true );
                                            if ( $position ) : ?>
                                                <p class="text-gray-600 text-sm"><?php echo esc_html( $position ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </article>
                                <?php endforeach; ?>
                            </div>
                            
                        <?php else : ?>
                            <!-- Default Results List -->
                            <div class="space-y-6">
                                <?php foreach ( $posts as $post ) : setup_postdata( $post ); ?>
                                    <article class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition duration-300">
                                        <h3 class="text-xl font-semibold mb-2">
                                            <a href="<?php the_permalink(); ?>" class="text-gray-900 hover:text-gold-600 transition duration-300">
                                                <?php the_title(); ?>
                                            </a>
                                        </h3>
                                        
                                        <div class="flex items-center text-sm text-gray-500 mb-3">
                                            <time datetime="<?php echo esc_attr( get_the_date( 'c' ) ); ?>">
                                                <?php echo get_the_date(); ?>
                                            </time>
                                            <?php if ( $post_type === 'post' && has_category() ) : ?>
                                                <span class="mx-2">•</span>
                                                <?php the_category( ', ' ); ?>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <div class="text-gray-600 mb-4">
                                            <?php the_excerpt(); ?>
                                        </div>
                                        
                                        <a href="<?php the_permalink(); ?>" class="inline-flex items-center text-gold-600 hover:text-gold-700 font-semibold">
                                            Read More
                                            <svg class="w-4 h-4 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                                            </svg>
                                        </a>
                                    </article>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach;
                wp_reset_postdata();
                ?>
                
                <!-- Pagination -->
                <div class="mt-12">
                    <?php
                    the_posts_pagination( array(
                        'mid_size' => 2,
                        'prev_text' => '&larr; Previous',
                        'next_text' => 'Next &rarr;',
                        'class' => 'flex justify-center space-x-2',
                    ) );
                    ?>
                </div>
                
            <?php else : ?>
                
                <!-- No Results -->
                <div class="max-w-2xl mx-auto text-center">
                    <div class="bg-white rounded-lg shadow-md p-12">
                        <svg class="w-24 h-24 text-gray-400 mx-auto mb-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                        </svg>
                        
                        <h2 class="text-2xl font-bold text-gray-900 mb-4">No Results Found</h2>
                        <p class="text-gray-600 mb-8">
                            Sorry, but nothing matched your search terms. Please try again with some different keywords.
                        </p>
                        
                        <div class="space-y-4">
                            <h3 class="text-lg font-semibold text-gray-900">Suggestions:</h3>
                            <ul class="text-left text-gray-600 space-y-2 max-w-md mx-auto">
                                <li class="flex items-start">
                                    <svg class="w-5 h-5 text-gold-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Check your spelling
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-5 h-5 text-gold-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Try more general keywords
                                </li>
                                <li class="flex items-start">
                                    <svg class="w-5 h-5 text-gold-500 mr-2 mt-0.5 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    Try different keywords
                                </li>
                            </ul>
                        </div>
                        
                        <div class="mt-8 space-y-4">
                            <a href="<?php echo esc_url( home_url( '/properties' ) ); ?>" class="inline-block bg-gold-600 text-white px-6 py-3 rounded-md hover:bg-gold-700 transition duration-300">
                                Browse All Properties
                            </a>
                            <p class="text-sm text-gray-500">or</p>
                            <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="inline-block text-gold-600 hover:text-gold-700 font-semibold">
                                Return to Homepage
                            </a>
                        </div>
                    </div>
                </div>
                
            <?php endif; ?>
        </div>
    </section>
</main><!-- #main -->

<?php
get_footer();