<?php
/**
 * Template Name: About Us
 * Description: Template for the About Us page
 *
 * @package Elite_Northeast_Realty
 */

get_header(); ?>

<section class="pt-32 pb-16 bg-white">
    <div class="max-w-7xl mx-auto px-6">
        <div class="flex items-center space-x-3 text-sm text-gray-500 mb-8">
            <div class="breadcrumb-item">
                <a href="<?php echo esc_url(home_url('/')); ?>" class="hover:text-primary transition-colors">Home</a>
            </div>
            <div class="breadcrumb-item">
                <span class="text-primary"><?php the_title(); ?></span>
            </div>
        </div>
        <div class="text-center mb-16">
            <h1 class="text-5xl md:text-6xl font-bold text-gray-900 mb-6"><?php the_title(); ?></h1>
            <?php if (function_exists('get_field') && get_field('page_subtitle')) : ?>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto"><?php echo esc_html(get_field('page_subtitle')); ?></p>
            <?php else : ?>
                <p class="text-xl text-gray-600 max-w-3xl mx-auto">Connecting families with their dream homes across Pennsylvania's most prestigious communities for over two decades</p>
            <?php endif; ?>
        </div>
    </div>
</section>

<section class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto px-6">
        <div class="bg-white rounded-2xl p-12 shadow-lg">
            <?php if (function_exists('get_field') && get_field('our_story_title')) : ?>
                <h2 class="text-3xl font-bold text-gray-900 mb-8"><?php echo esc_html(get_field('our_story_title')); ?></h2>
            <?php else : ?>
                <h2 class="text-3xl font-bold text-gray-900 mb-8">Our Story</h2>
            <?php endif; ?>
            
            <div class="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                <?php if (function_exists('get_field') && get_field('our_story_content')) : ?>
                    <?php echo wp_kses_post(get_field('our_story_content')); ?>
                <?php else : ?>
                    <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                        <?php the_content(); ?>
                    <?php endwhile; endif; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-6">
        <div class="text-center mb-16">
            <?php if (function_exists('get_field') && get_field('service_areas_title')) : ?>
                <h2 class="text-4xl font-bold text-gray-900 mb-4"><?php echo esc_html(get_field('service_areas_title')); ?></h2>
            <?php else : ?>
                <h2 class="text-4xl font-bold text-gray-900 mb-4">Our Service Areas</h2>
            <?php endif; ?>
            
            <?php if (function_exists('get_field') && get_field('service_areas_subtitle')) : ?>
                <p class="text-xl text-gray-600"><?php echo esc_html(get_field('service_areas_subtitle')); ?></p>
            <?php else : ?>
                <p class="text-xl text-gray-600">Proudly serving communities across Pennsylvania with specialized local expertise</p>
            <?php endif; ?>
        </div>
        <div class="grid lg:grid-cols-2 gap-16 items-center">
            <div class="county-map bg-white rounded-2xl p-8 shadow-lg">
                <?php if (function_exists('get_field') && get_field('service_area_map')) : ?>
                    <img src="<?php echo esc_url(get_field('service_area_map')['url']); ?>" 
                         alt="<?php echo esc_attr(get_field('service_area_map')['alt']); ?>" 
                         class="w-full h-auto rounded-lg">
                <?php else : ?>
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/images/service-area-map-placeholder.svg" 
                         alt="Pennsylvania Counties Service Map" 
                         class="w-full h-auto rounded-lg">
                <?php endif; ?>
            </div>
            <div>
                <?php if (function_exists('get_field') && get_field('market_knowledge_title')) : ?>
                    <h3 class="text-2xl font-bold text-gray-900 mb-6"><?php echo esc_html(get_field('market_knowledge_title')); ?></h3>
                <?php else : ?>
                    <h3 class="text-2xl font-bold text-gray-900 mb-6">Specialized Market Knowledge</h3>
                <?php endif; ?>
                
                <?php if (function_exists('get_field') && get_field('market_knowledge_description')) : ?>
                    <p class="text-gray-700 mb-6 leading-relaxed"><?php echo esc_html(get_field('market_knowledge_description')); ?></p>
                <?php else : ?>
                    <p class="text-gray-700 mb-6 leading-relaxed">Our expertise spans across multiple counties in Pennsylvania, with particular strength in the highlighted regions shown on the map. Each area presents unique opportunities and challenges, and our local specialists possess intimate knowledge of market trends, school districts, community amenities, and neighborhood characteristics.</p>
                <?php endif; ?>
                
                <div class="grid grid-cols-2 gap-4 mb-8">
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center space-x-3 mb-2">
                            <div class="w-3 h-3 bg-green-500 rounded-full"></div>
                            <span class="font-semibold text-gray-900">Primary Markets</span>
                        </div>
                        <p class="text-sm text-gray-600">Counties where we maintain the strongest presence and deepest market expertise</p>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-4">
                        <div class="flex items-center space-x-3 mb-2">
                            <div class="w-3 h-3 bg-gray-400 rounded-full"></div>
                            <span class="font-semibold text-gray-900">Extended Coverage</span>
                        </div>
                        <p class="text-sm text-gray-600">Additional areas where we provide comprehensive real estate services</p>
                    </div>
                </div>
                
                <?php if (function_exists('have_rows') && have_rows('service_features')) : ?>
                    <div class="space-y-4">
                        <?php while (have_rows('service_features')) : the_row(); ?>
                            <div class="flex items-center space-x-3">
                                <div class="w-5 h-5 flex items-center justify-center text-primary">
                                    <i class="ri-check-line"></i>
                                </div>
                                <span class="text-gray-700"><?php echo esc_html(get_sub_field('feature_text')); ?></span>
                            </div>
                        <?php endwhile; ?>
                    </div>
                <?php else : ?>
                    <div class="space-y-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-5 h-5 flex items-center justify-center text-primary">
                                <i class="ri-check-line"></i>
                            </div>
                            <span class="text-gray-700">Comprehensive market analysis and pricing strategies</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-5 h-5 flex items-center justify-center text-primary">
                                <i class="ri-check-line"></i>
                            </div>
                            <span class="text-gray-700">Local school district and community information</span>
                        </div>
                        <div class="flex items-center space-x-3">
                            <div class="w-5 h-5 flex items-center justify-center text-primary">
                                <i class="ri-check-line"></i>
                            </div>
                            <span class="text-gray-700">Neighborhood trend analysis and future development insights</span>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="py-16 bg-gray-50">
    <div class="max-w-4xl mx-auto px-6">
        <div class="bg-white rounded-2xl p-12 shadow-lg">
            <?php if (function_exists('get_field') && get_field('mission_values_title')) : ?>
                <h2 class="text-3xl font-bold text-gray-900 mb-8"><?php echo esc_html(get_field('mission_values_title')); ?></h2>
            <?php else : ?>
                <h2 class="text-3xl font-bold text-gray-900 mb-8">Our Mission & Values</h2>
            <?php endif; ?>
            
            <div class="prose prose-lg max-w-none text-gray-700 leading-relaxed">
                <?php if (function_exists('get_field') && get_field('mission_values_content')) : ?>
                    <?php echo wp_kses_post(get_field('mission_values_content')); ?>
                <?php else : ?>
                    <p class="mb-6">At Elite Northeast Realty, our mission is to transform the real estate experience by combining traditional values with modern innovation. We are committed to providing exceptional service that exceeds expectations while maintaining the highest standards of integrity and professionalism.</p>
                    <p class="mb-6">We believe that every client deserves personalized attention and expert guidance throughout their real estate journey. Whether you're a first-time homebuyer, seasoned investor, or looking to sell your property, we approach each relationship with the same level of dedication and care.</p>
                    <p class="mb-6">Our core values guide everything we do: transparency in all communications, reliability in our commitments, expertise in market knowledge, and innovation in our approach to real estate marketing and technology. These principles have earned us the trust of thousands of families and established our reputation as leaders in the Northeast Pennsylvania real estate market.</p>
                    <p>As we look to the future, we remain committed to evolving with the changing needs of our clients while staying true to the fundamental values that have made us successful. We continue to invest in training, technology, and community involvement to ensure we remain your trusted real estate partner for years to come.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<section class="py-20 bg-white">
    <div class="max-w-7xl mx-auto px-6">
        <div class="bg-gradient-to-r from-primary/10 to-secondary/10 rounded-2xl p-12 relative overflow-hidden">
            <div class="grid md:grid-cols-2 gap-12 items-center">
                <div class="relative z-10">
                    <?php if (function_exists('get_field') && get_field('cta_title')) : ?>
                        <h2 class="text-4xl font-bold text-gray-900 mb-4"><?php echo esc_html(get_field('cta_title')); ?></h2>
                    <?php else : ?>
                        <h2 class="text-4xl font-bold text-gray-900 mb-4">Ready to Find Your Dream Home?</h2>
                    <?php endif; ?>
                    
                    <?php if (function_exists('get_field') && get_field('cta_description')) : ?>
                        <p class="text-xl text-gray-600 mb-8"><?php echo esc_html(get_field('cta_description')); ?></p>
                    <?php else : ?>
                        <p class="text-xl text-gray-600 mb-8">Let our experienced team guide you through every step of your real estate journey. From initial consultation to closing day, we're here to make your experience seamless and successful.</p>
                    <?php endif; ?>
                    
                    <div class="flex flex-col sm:flex-row gap-4">
                        <?php if (function_exists('get_field') && get_field('cta_primary_button_text') && get_field('cta_primary_button_link')) : ?>
                            <a href="<?php echo esc_url(get_field('cta_primary_button_link')); ?>" 
                               class="bg-primary text-white px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold flex items-center justify-center space-x-2 !rounded-button whitespace-nowrap">
                                <span><?php echo esc_html(get_field('cta_primary_button_text')); ?></span>
                                <div class="w-5 h-5 flex items-center justify-center">
                                    <i class="ri-calendar-line"></i>
                                </div>
                            </a>
                        <?php else : ?>
                            <a href="<?php echo esc_url(home_url('/contact')); ?>" 
                               class="bg-primary text-white px-8 py-4 rounded-lg hover:bg-blue-700 transition-colors font-semibold flex items-center justify-center space-x-2 !rounded-button whitespace-nowrap">
                                <span>Schedule Consultation</span>
                                <div class="w-5 h-5 flex items-center justify-center">
                                    <i class="ri-calendar-line"></i>
                                </div>
                            </a>
                        <?php endif; ?>
                        
                        <?php if (function_exists('get_field') && get_field('cta_secondary_button_text') && get_field('cta_secondary_button_link')) : ?>
                            <a href="<?php echo esc_url(get_field('cta_secondary_button_link')); ?>" 
                               class="bg-white text-gray-900 px-8 py-4 rounded-lg hover:bg-gray-50 transition-colors font-semibold flex items-center justify-center space-x-2 border border-gray-200 !rounded-button whitespace-nowrap">
                                <span><?php echo esc_html(get_field('cta_secondary_button_text')); ?></span>
                                <div class="w-5 h-5 flex items-center justify-center">
                                    <i class="ri-search-line"></i>
                                </div>
                            </a>
                        <?php else : ?>
                            <a href="<?php echo esc_url(home_url('/properties')); ?>" 
                               class="bg-white text-gray-900 px-8 py-4 rounded-lg hover:bg-gray-50 transition-colors font-semibold flex items-center justify-center space-x-2 border border-gray-200 !rounded-button whitespace-nowrap">
                                <span>Browse Properties</span>
                                <div class="w-5 h-5 flex items-center justify-center">
                                    <i class="ri-search-line"></i>
                                </div>
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="relative">
                    <?php if (function_exists('get_field') && get_field('cta_image')) : ?>
                        <img src="<?php echo esc_url(get_field('cta_image')['url']); ?>" 
                             alt="<?php echo esc_attr(get_field('cta_image')['alt']); ?>" 
                             class="rounded-xl shadow-2xl">
                    <?php else : ?>
                        <img src="<?php echo get_template_directory_uri(); ?>/assets/images/consultation-placeholder.svg" 
                             alt="Consultation" 
                             class="rounded-xl shadow-2xl">
                    <?php endif; ?>
                    
                    <div class="absolute -bottom-6 -right-6 bg-white rounded-2xl p-6 shadow-xl">
                        <div class="flex items-center space-x-4">
                            <?php if (function_exists('get_field') && get_field('success_metric_number')) : ?>
                                <div class="text-4xl font-bold text-primary"><?php echo esc_html(get_field('success_metric_number')); ?></div>
                            <?php else : ?>
                                <div class="text-4xl font-bold text-primary">2,500+</div>
                            <?php endif; ?>
                            
                            <?php if (function_exists('get_field') && get_field('success_metric_text')) : ?>
                                <div class="text-gray-600"><?php echo wp_kses_post(get_field('success_metric_text')); ?></div>
                            <?php else : ?>
                                <div class="text-gray-600">Successful<br>transactions</div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php get_footer(); ?>