<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 *
 * @package Elite_Northeast_Realty
 */

get_header(); ?>

<div id="primary" class="content-area">
    <main id="main" class="site-main container mx-auto px-4 py-8">

        <?php if ( have_posts() ) : ?>

            <?php if ( is_home() && ! is_front_page() ) : ?>
                <header class="page-header mb-8">
                    <h1 class="page-title text-3xl font-bold"><?php single_post_title(); ?></h1>
                </header>
            <?php endif; ?>

            <div class="posts-grid grid gap-8 md:grid-cols-2 lg:grid-cols-3">
                <?php
                /* Start the Loop */
                while ( have_posts() ) :
                    the_post();
                ?>

                    <article id="post-<?php the_ID(); ?>" <?php post_class( 'bg-white rounded-lg shadow-md overflow-hidden' ); ?>>
                        <?php if ( has_post_thumbnail() ) : ?>
                            <div class="post-thumbnail">
                                <a href="<?php the_permalink(); ?>" aria-hidden="true" tabindex="-1">
                                    <?php the_post_thumbnail( 'medium_large', array( 'class' => 'w-full h-48 object-cover' ) ); ?>
                                </a>
                            </div>
                        <?php endif; ?>

                        <div class="p-6">
                            <header class="entry-header mb-4">
                                <?php
                                if ( is_singular() ) :
                                    the_title( '<h1 class="entry-title text-2xl font-bold mb-2">', '</h1>' );
                                else :
                                    the_title( '<h2 class="entry-title text-xl font-bold mb-2"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark" class="text-gray-900 hover:text-blue-600">', '</a></h2>' );
                                endif;
                                ?>

                                <?php if ( 'post' === get_post_type() ) : ?>
                                    <div class="entry-meta text-sm text-gray-600">
                                        <?php
                                        printf(
                                            /* translators: %s: post date */
                                            esc_html__( 'Posted on %s', 'elite-northeast-realty' ),
                                            '<time datetime="' . esc_attr( get_the_date( DATE_W3C ) ) . '">' . esc_html( get_the_date() ) . '</time>'
                                        );

                                        printf(
                                            /* translators: %s: post author */
                                            esc_html__( ' by %s', 'elite-northeast-realty' ),
                                            '<span class="author vcard"><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . esc_html( get_the_author() ) . '</a></span>'
                                        );
                                        ?>
                                    </div>
                                <?php endif; ?>
                            </header>

                            <div class="entry-content mb-4">
                                <?php
                                if ( is_singular() ) :
                                    the_content();

                                    wp_link_pages( array(
                                        'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'elite-northeast-realty' ),
                                        'after'  => '</div>',
                                    ) );
                                else :
                                    the_excerpt();
                                ?>
                                    <a href="<?php the_permalink(); ?>" class="read-more inline-block mt-2 text-blue-600 hover:text-blue-800 font-medium">
                                        <?php esc_html_e( 'Read More', 'elite-northeast-realty' ); ?> →
                                    </a>
                                <?php endif; ?>
                            </div>

                            <?php if ( is_singular() ) : ?>
                                <footer class="entry-footer">
                                    <?php
                                    /* translators: %s: Name of current post. Only visible to screen readers */
                                    edit_post_link(
                                        sprintf(
                                            wp_kses(
                                                __( 'Edit <span class="screen-reader-text">%s</span>', 'elite-northeast-realty' ),
                                                array(
                                                    'span' => array(
                                                        'class' => array(),
                                                    ),
                                                )
                                            ),
                                            wp_kses_post( get_the_title() )
                                        ),
                                        '<span class="edit-link">',
                                        '</span>'
                                    );
                                    ?>
                                </footer>
                            <?php endif; ?>
                        </div>
                    </article>

                <?php
                endwhile;
                ?>
            </div>

            <div class="pagination mt-8">
                <?php
                the_posts_navigation( array(
                    'prev_text' => __( '← Older Posts', 'elite-northeast-realty' ),
                    'next_text' => __( 'Newer Posts →', 'elite-northeast-realty' ),
                    'class'     => 'flex justify-between',
                ) );
                ?>
            </div>

        <?php else : ?>

            <section class="no-results not-found">
                <header class="page-header mb-8">
                    <h1 class="page-title text-3xl font-bold"><?php esc_html_e( 'Nothing Found', 'elite-northeast-realty' ); ?></h1>
                </header>

                <div class="page-content">
                    <?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

                        <p class="mb-4">
                            <?php
                            printf(
                                wp_kses(
                                    /* translators: 1: link to WP admin new post page. */
                                    __( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'elite-northeast-realty' ),
                                    array(
                                        'a' => array(
                                            'href' => array(),
                                        ),
                                    )
                                ),
                                esc_url( admin_url( 'post-new.php' ) )
                            );
                            ?>
                        </p>

                    <?php elseif ( is_search() ) : ?>

                        <p class="mb-4"><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'elite-northeast-realty' ); ?></p>
                        <?php get_search_form(); ?>

                    <?php else : ?>

                        <p class="mb-4"><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'elite-northeast-realty' ); ?></p>
                        <?php get_search_form(); ?>

                    <?php endif; ?>
                </div>
            </section>

        <?php endif; ?>

    </main>
</div>

<?php
get_sidebar();
get_footer();