<?php
/**
 * Custom Nav Walker for Elite Realty Theme
 *
 * @package Elite_Northeast_Realty
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Elite_Realty_Nav_Walker extends Walker_Nav_Menu {
    
    /**
     * Start Level - Outputs the beginning of a sub-menu
     */
    public function start_lvl( &$output, $depth = 0, $args = null ) {
        $indent = str_repeat( "\t", $depth );
        $output .= "\n$indent<div class=\"absolute top-full left-0 mt-2 bg-white rounded-lg shadow-lg py-2 w-48 hidden group-hover:block\">\n";
    }

    /**
     * End Level - Outputs the end of a sub-menu
     */
    public function end_lvl( &$output, $depth = 0, $args = null ) {
        $indent = str_repeat( "\t", $depth );
        $output .= "$indent</div>\n";
    }

    /**
     * Start Element - Outputs the beginning of each menu item
     */
    public function start_el( &$output, $item, $depth = 0, $args = null, $id = 0 ) {
        $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

        $classes = empty( $item->classes ) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;

        // Check if item has children
        $has_children = in_array( 'menu-item-has-children', $classes );

        $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );
        
        if ( $depth === 0 ) {
            if ( $has_children ) {
                $class_names .= ' relative group';
            }
        }

        $class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

        $id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
        $id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

        if ( $depth === 0 ) {
            $output .= $indent . '';
        } else {
            $output .= $indent . '';
        }

        $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
        $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

        if ( $depth === 0 ) {
            if ( $has_children ) {
                $attributes .= ' class="text-white hover:text-primary transition-colors text-lg font-medium flex items-center"';
            } else {
                $attributes .= ' class="text-white hover:text-primary transition-colors text-lg font-medium"';
            }
        } else {
            $attributes .= ' class="block px-4 py-2 text-gray-800 hover:bg-gray-100"';
        }

        $item_output = $args->before ?? '';
        
        if ( $depth === 0 && $has_children ) {
            $item_output .= '<button' . $attributes . '>';
        } else {
            $item_output .= '<a' . $attributes . '>';
        }
        
        $item_output .= ( $args->link_before ?? '' ) . apply_filters( 'the_title', $item->title, $item->ID ) . ( $args->link_after ?? '' );
        
        if ( $depth === 0 && $has_children ) {
            $item_output .= '<div class="w-4 h-4 flex items-center justify-center ml-1"><i class="ri-arrow-down-s-line"></i></div>';
            $item_output .= '</button>';
        } else {
            $item_output .= '</a>';
        }
        
        $item_output .= $args->after ?? '';

        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
    }

    /**
     * End Element - Outputs the end of each menu item
     */
    public function end_el( &$output, $item, $depth = 0, $args = null ) {
        if ( $depth === 0 ) {
            $output .= "\n";
        } else {
            $output .= "\n";
        }
    }
}