<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php wp_head(); ?>
</head>
<body <?php body_class('bg-gray-50'); ?>>
    <nav class="navbar fixed top-0 left-0 right-0 z-50 px-6 py-4">
        <div class="max-w-7xl mx-auto flex items-center justify-between">
            <div class="font-['Pacifico'] text-2xl text-white font-bold">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <?php bloginfo('name'); ?>
                </a>
            </div>
            <div class="hidden md:flex items-center space-x-8">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'primary',
                    'container' => false,
                    'menu_class' => 'hidden md:flex items-center space-x-8',
                    'fallback_cb' => false,
                    'walker' => new Elite_Realty_Nav_Walker(),
                ));
                ?>
                <a href="<?php echo esc_url(home_url('/join-us')); ?>" class="relative overflow-hidden bg-gradient-to-r from-primary to-blue-600 text-white text-lg font-medium px-8 py-2.5 rounded-full ml-4 !rounded-button group hover:shadow-lg hover:-translate-y-0.5 transition-all duration-300 ease-out">
                    <span class="relative z-10 flex items-center">
                        Join Us!
                        <div class="w-4 h-4 flex items-center justify-center ml-1 transform group-hover:translate-x-1 transition-transform">
                            <i class="ri-arrow-right-line"></i>
                        </div>
                    </span>
                    <div class="absolute inset-0 bg-gradient-to-r from-blue-600 to-primary opacity-0 group-hover:opacity-100 transition-opacity duration-300 ease-out"></div>
                </a>
            </div>
            <button class="md:hidden w-8 h-8 flex items-center justify-center text-white mobile-menu-toggle">
                <i class="ri-menu-line ri-lg"></i>
            </button>
        </div>
    </nav>
    
    <!-- Mobile Menu -->
    <div class="mobile-menu fixed inset-0 bg-black bg-opacity-50 z-40 hidden">
        <div class="bg-white w-80 h-full ml-auto shadow-xl">
            <div class="p-6">
                <button class="mobile-menu-close mb-8 text-gray-600 hover:text-gray-900">
                    <i class="ri-close-line ri-xl"></i>
                </button>
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'mobile',
                    'container' => false,
                    'menu_class' => 'space-y-4',
                    'fallback_cb' => false,
                ));
                ?>
            </div>
        </div>
    </div>