<?php
flexmlsPortalPopup::popup_portal('detail_page');
$api_prefs = $fmc_api->GetPreferences();
$phone_req  = in_array('phone', $api_prefs['RequiredFields']);
?>
<div class="flexmls-listing-details flexmls-v2-widget flexmls-widthchange-wrapper flexmls-body-font property_detail_page">
	<?php $has_search_return = ! empty($_GET['search_referral_url']); ?>
	<div class="flexmls-actions-wrapper listing-section <?php echo $has_search_return ? 'has-return-button' : ''; ?>">
		<?php if ($has_search_return) : ?>
			<?php $search_referral_url = $_GET['search_referral_url']; ?>
			<?php $back_button_link = wp_validate_redirect($search_referral_url, flexmlsConnect::get_destination_link());
			?>
			<?php
			$back_to_search_link = '';
			if (strpos($search_referral_url, "'")) {
				$back_to_search_link = stripslashes($search_referral_url);
			} else {
				$back_to_search_link = wp_validate_redirect($search_referral_url, flexmlsConnect::get_destination_link());
			}
			?>
			<a class="back-to-search-link flexmls-primary-color-font" href="<?php echo $back_to_search_link; ?>">&larr; Back to search</a>
		<?php endif; ?>
		<button class="flexmls-btn flexmls-btn-primary flexmls-primary-color-background" onclick="flexmls_connect.contactForm({
			'title': 'Contact agent',
			'subject': '<?php echo $one_line_address_add_slashes; ?> - MLS# <?php echo addslashes($sf['ListingId']) ?> ',
			'agentEmail': '<?php echo $this->contact_form_agent_email($sf); ?>',
			'officeEmail': '<?php echo $this->contact_form_office_email($sf); ?>',
			'phoneRequired': <?php echo $phone_req ? 'true' : 'false'; ?>,
			'id': '<?php echo addslashes($sf['ListingId']); ?>'
		<?php if (isset($options['contact_disclaimer'])) : ?>
			,'disclaimer': '<?php echo esc_js(flexmlsConnect::get_contact_disclaimer()); ?>'
		<?php endif; ?>
		});">
			Contact agent
		</button>
	</div>
	
	<div class="property_detail_wrapper">
		<div class="slideshow-wrapper listing-section">
			<?php if ($count_photos > 0) : ?>
				<div id="listing-slideshowd" class="property_detail owl-carouseld">
					<?php $firstImage = $sf['Photos'][0]['Uri640'] ?? ''; ?>
					<div class="gallery-main">
						<img id="mainImage" src="<?php echo esc_url($firstImage); ?>" alt="Main Property Image" class="w-full h-full object-cover rounded-lg">
					</div>
					<?php
					$totalPhotos = count($sf['Photos']);
					foreach ($sf['Photos'] as $index => $p) :
						if ($index < 3) : ?>
							<div class="gallery-thumb">
								<img src="<?php echo $p['Uri640']; ?>" alt="Photo <?php echo $index + 1; ?>" class="w-full h-full object-cover rounded-lg gallery-thumb" onclick="changeMainImage(this.src)">
							</div>
						<?php elseif ($index == 3) :
							$remaining = $totalPhotos - 3; ?>
							<div class="gallery-thumb thumb_more_images position-relative" onclick="changeMainImage('<?php echo $p['Uri640']; ?>')">
								<img src="<?php echo $p['Uri640']; ?>" alt="More Photos" class="w-full h-full object-cover rounded-lg opacity-70">
								<div class="load_more_images" id="load_more_images">
									+<?php echo $remaining; ?> more
								</div>
							</div>
							<?php break; ?>
					<?php endif;
					endforeach;
					?>
				</div>
			<?php endif; ?>
			<div class="bg-white rounded-lg shadow-sm properties_details_conatiner">
				<div class="flex items-center justify-between mb-4">
					<h1 class="price">$525,000</h1>
				</div>
				<p class="address">525 Maple Street, Mountain Top, PA 18707</p>
				<div class="flexmls_details_icons">
					<?php
					$main_details = [
						['field' => 'BedsTotal', 'title' => 'beds', 'label' => '<svg width="24" height="24" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M13.8374 6.41144V11.665H12.6699V9.91384H3.33016V11.665H2.16269V2.32531H3.33016V8.16264H8.00002V4.07651H11.5024C11.9227 4.07651 12.3119 4.18158 12.6699 4.39172C13.0279 4.60187 13.312 4.88595 13.5221 5.24397C13.7323 5.602 13.8374 5.99115 13.8374 6.41144ZM12.6699 8.16264V6.41144C12.6699 6.2013 12.6174 6.00672 12.5123 5.82771C12.4072 5.6487 12.2652 5.50665 12.0862 5.40158C11.9071 5.29651 11.7126 5.24397 11.5024 5.24397H9.16749V8.16264H12.6699ZM5.66509 6.41144C5.82853 6.41144 5.96668 6.35501 6.07954 6.24216C6.19239 6.1293 6.24882 5.99115 6.24882 5.82771C6.24882 5.66426 6.19239 5.52611 6.07954 5.41326C5.96668 5.3004 5.82853 5.24397 5.66509 5.24397C5.50164 5.24397 5.36349 5.3004 5.25064 5.41326C5.13778 5.52611 5.08136 5.66426 5.08136 5.82771C5.08136 5.99115 5.13778 6.1293 5.25064 6.24216C5.36349 6.35501 5.50164 6.41144 5.66509 6.41144ZM5.66509 7.57891C5.34598 7.57891 5.05217 7.50108 4.78365 7.34541C4.51513 7.18975 4.30304 6.97766 4.14738 6.70914C3.99172 6.44063 3.91389 6.14681 3.91389 5.82771C3.91389 5.5086 3.99172 5.21479 4.14738 4.94627C4.30304 4.67775 4.51513 4.46566 4.78365 4.31C5.05217 4.15434 5.34598 4.07651 5.66509 4.07651C5.9842 4.07651 6.27801 4.15434 6.54653 4.31C6.81504 4.46566 7.02713 4.67775 7.18279 4.94627C7.33846 5.21479 7.41629 5.5086 7.41629 5.82771C7.41629 6.14681 7.33846 6.44063 7.18279 6.70914C7.02713 6.97766 6.81504 7.18975 6.54653 7.34541C6.27801 7.50108 5.9842 7.57891 5.66509 7.57891Z" fill="#6B7280"/>
							</svg>'],
						['field' => 'BathsTotal', 'title' => 'baths', 'label' => '<svg width="24" height="24" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7.95502 2.30999L5.07335 5.20332C4.54446 5.72443 4.18668 6.33888 4.00002 7.04665C3.82113 7.73888 3.82113 8.4311 4.00002 9.12332C4.18668 9.8311 4.54252 10.4475 5.06752 10.9725C5.59252 11.4975 6.20891 11.8533 6.91668 12.04C7.60891 12.2189 8.30113 12.2189 8.99335 12.04C9.70113 11.8533 10.3175 11.4975 10.8425 10.9725C11.3675 10.4475 11.7234 9.8311 11.91 9.12332C12.0889 8.4311 12.0889 7.73888 11.91 7.04665C11.7234 6.33888 11.3656 5.72443 10.8367 5.20332L7.95502 2.30999ZM7.95502 0.664987L11.665 4.37499C12.3417 5.04388 12.7967 5.83721 13.03 6.75499C13.2634 7.64165 13.2634 8.52832 13.03 9.41499C12.7967 10.3328 12.3436 11.128 11.6709 11.8008C10.9981 12.4736 10.2028 12.9305 9.28502 13.1717C8.39835 13.3972 7.51168 13.3972 6.62502 13.1717C5.70724 12.9305 4.91196 12.4736 4.23918 11.8008C3.56641 11.128 3.11335 10.3328 2.88002 9.41499C2.64668 8.52832 2.64668 7.64165 2.88002 6.75499C3.11335 5.83721 3.56835 5.04388 4.24502 4.37499L7.95502 0.664987Z" fill="#6B7280"/>
                          </svg>'],
					];

					if (flexmlsConnect::is_not_blank_or_restricted($sf['BuildingAreaTotal'])) {
						$main_details[] = ['field' => 'BuildingAreaTotal', 'title' => 'sqft', 'label' => '<svg width="24" height="24" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13.015 1.75C13.1783 1.75 13.3164 1.80639 13.4291 1.91917C13.5419 2.03194 13.5983 2.17 13.5983 2.33333V11.6667C13.5983 11.83 13.5419 11.9681 13.4291 12.0808C13.3164 12.1936 13.1783 12.25 13.015 12.25H2.51497C2.35164 12.25 2.21359 12.1936 2.10081 12.0808C1.98803 11.9681 1.93164 11.83 1.93164 11.6667V2.33333C1.93164 2.17 1.98803 2.03194 2.10081 1.91917C2.21359 1.80639 2.35164 1.75 2.51497 1.75H13.015ZM12.4316 2.91667H3.09831V11.0833H12.4316V2.91667ZM8.34831 9.91667V8.75H10.0983V7H11.265V9.91667H8.34831ZM7.18164 4.08333V5.25H5.43164V7H4.26497V4.08333H7.18164Z" fill="#6B7280"/>
                        </svg>', 'value' => number_format($sf['BuildingAreaTotal'])];
					} elseif (flexmlsConnect::is_not_blank_or_restricted($sf['LivingArea'])) {
						$main_details[] = ['field' => 'LivingArea', 'title' => 'sqft', 'label' => '<svg width="24" height="24" viewBox="0 0 16 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M13.015 1.75C13.1783 1.75 13.3164 1.80639 13.4291 1.91917C13.5419 2.03194 13.5983 2.17 13.5983 2.33333V11.6667C13.5983 11.83 13.5419 11.9681 13.4291 12.0808C13.3164 12.1936 13.1783 12.25 13.015 12.25H2.51497C2.35164 12.25 2.21359 12.1936 2.10081 12.0808C1.98803 11.9681 1.93164 11.83 1.93164 11.6667V2.33333C1.93164 2.17 1.98803 2.03194 2.10081 1.91917C2.21359 1.80639 2.35164 1.75 2.51497 1.75H13.015ZM12.4316 2.91667H3.09831V11.0833H12.4316V2.91667ZM8.34831 9.91667V8.75H10.0983V7H11.265V9.91667H8.34831ZM7.18164 4.08333V5.25H5.43164V7H4.26497V4.08333H7.18164Z" fill="#6B7280"/>
                        </svg>', 'value' => number_format($sf['LivingArea'])];
					}
					?>

					<?php foreach ($main_details as $detail) :
						if (flexmlsConnect::is_not_blank_or_restricted($sf[$detail['field']])) :
							$value = $detail['value'] ?? $sf[$detail['field']]; ?>
							<div class="flexmls_detail_icon_list flex items-center gap-1 mr-4">
								<?php echo $detail['label']; ?>
								<div>
									<span class="detail-value font-medium text-gray-800"><?php echo esc_html($value); ?></span>
									<span class="detail-title font-medium text-gray-800"><?php echo esc_html($detail['title']); ?></span>
								</div>
							</div>
					<?php endif;
					endforeach;
					?>
				</div>
			</div>
			
			<?php if (flexmlsConnect::is_not_blank_or_restricted($sf['PublicRemarks'])) : ?>
				<div class="bg-rounted">
					<h2 class="flexmls-title-larger flexmls-primary-color-font flexmls-heading-font">Description</h2>
					<div class="flexmls-description">
						<?php echo $sf['PublicRemarks']; ?>
						<?php if ($sf['Supplement']) : ?>
							<p><strong>Supplements: </strong><?php echo $sf['Supplement']; ?></p>
						<?php endif; ?>
					</div>
					<?php if ($sf['OpenHousesCount']  > 0) : ?>
						<div class="open-houses-list-details">
							<h2 class="flexmls-title-larger flexmls-primary-color-font flexmls-heading-font">Open Houses</h2>
							<?php foreach ($sf['OpenHouses'] as $OpenHouse) :
								$todayDate = date("d.m.Y H:i");
								$match_date = date('d.m.Y H:i', strtotime($OpenHouse['Date']));
								if ($todayDate == $match_date) {
									$openingDay = 'Today, ';
								} elseif (date("+1 day", strtotime($todayDate)) == $match_date) {
									$openingDay = 'Tomorrow, ';
								} else {
									$openingDay = date('l, F d, ', strtotime($OpenHouse['Date']));
								}

							?>
								<div class="open-house-list-inner"><?php echo $openingDay . $OpenHouse['StartTime'] . ' - ' . $OpenHouse['EndTime']; ?></div>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				</div>
			<?php endif; ?>
			<div class="bg-rounted property_more_information">
				<div class="listing-section more-information-toggle">
					<h2 class="detail_section_header flexmls-primary-color-font flexmls-heading-font">More Information </h2>
				</div>
				<?php if (!empty($this->property_detail_values)) : ?>
					<div class="property-faq">
						<?php $isFirst = true; 
						foreach ($this->property_detail_values as $k => $v) : ?>
							<div class="faq-item <?php echo $isFirst ? 'open' : ''; ?>">
								<button class="faq-question">
									<span><?php echo esc_html($k); ?></span>
									<span class="arrow"><svg width="18" height="18" viewBox="0 0 23 21" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M11.985 14.1575L16.675 9.45L17.9175 10.6925L11.11 17.5L4.30249 10.6925L5.54499 9.45L10.235 14.1575V3.5H11.985V14.1575Z" fill="black"/>
</svg>
</span>
								</button>

								<div class="faq-answer <?php echo $isFirst ? 'active' : ''; ?>">
									<div class="faq-grid">
										<?php foreach ($v as $key => $value) : ?>
											<div class="faq-detail">
												<span class="value"><?php echo $value; ?></span>
											</div>
										<?php endforeach; ?>
									</div>
								</div>
							</div>
						<?php $isFirst = false; 
					endforeach; ?>
					</div>
					<!-- <div class="property-tabs">
						<ul class="custom_tab_buttons flex flex-wrap gap-2 mb-4 border-b">
							<?php //$first = true; $tabIndex = 0; ?>
							<?php //foreach ($this->property_detail_values as $k => $v) : ?>
								<li>
									<button 
										class="tab-button px-4 py-2 rounded-t-md text-sm font-semibold <?php //echo $first ? 'active bg-gray-200' : 'bg-gray-100'; ?>" 
										data-tab="tab-<?php //echo $tabIndex; ?>">
										<?php //echo esc_html($k); ?>
									</button>
								</li>
								<?php //$first = false; $tabIndex++; ?>
							<?php //endforeach; ?>
						</ul>

						<?php //$first = true; $tabIndex = 0; ?>
						<?php //foreach ($this->property_detail_values as $k => $v) : ?>
							<div class="custom_tab_content <?php //echo $first ? 'active' : 'hidden'; ?>" id="tab-<?php //echo $tabIndex; ?>">
								<div class="grid grid-cols-2 gap-4">
									<?php //foreach ($v as $key => $value) : ?>
										<div class="detail-item">
											<span class="font-medium"><?php //echo $value; ?></span>
										</div>
									<?php //endforeach; ?>
								</div>
							</div>
							<?php //$first = false; $tabIndex++; ?>
						<?php //endforeach; ?>
					</div> -->
					<script>
						document.addEventListener("DOMContentLoaded", function () {

							const questions = document.querySelectorAll('.faq-question');
							questions.forEach(question => {
								question.addEventListener('click', function () {
									const parent = this.closest('.faq-item');
									const answer = parent.querySelector('.faq-answer');

									document.querySelectorAll('.faq-item').forEach(item => {
										if (item !== parent) {
											item.classList.remove('open');
											item.querySelector('.faq-answer').classList.remove('active');
										}
									});

									parent.classList.toggle('open');
									answer.classList.toggle('active');
								});
							});

							const buttons = document.querySelectorAll('.custom_tab_buttons .tab-button');
							const contents = document.querySelectorAll('.custom_tab_content');

							buttons.forEach(btn => {
								btn.addEventListener('click', function () {
									buttons.forEach(b => b.classList.remove('active', 'bg-gray-200'));
									this.classList.add('active', 'bg-gray-200');

									contents.forEach(c => c.classList.add('hidden'));

									const tabId = this.getAttribute('data-tab');
									document.getElementById(tabId).classList.remove('hidden');
									document.getElementById(tabId).classList.remove('active');
								});
							});
						});
					</script>
				<?php endif; ?>
			</div>
			<?php if (! empty($property_features_values)) : ?>
				<div class="bg-rounted property_features">
					<div class="details-section">
						<h3 class="detail_section_header flexmls-title-larger flexmls-heading-font">Property Features</h3>
						<div class="property-details-wrapper">
							<?php foreach ($property_features_values as $k => $v) : ?>
								<?php
								$value = "<b>" . $k . ": </b>";
								foreach ($v as $x) {
									$value .= $x . "; ";
								}
								$value = trim($value, "; ");
								?>
								<span class="detail-value"><?php echo $value; ?></span>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			<?php endif; ?>
			<?php $room_count = isset($room_values[0]) ? count($room_values[0]) : false; ?>
			<?php if ($room_count) : ?>
				<div class="bg-rounted room_information">
					<div class="details-section rooms-section">
						<h3 class="property-details-wrapper flexmls-title-large flexmls-heading-font">Room Information</h3>

						<div class="property-details-accordion">
    <?php $isFirst = true; ?>
    <?php foreach ($room_values[0] as $i => $room) : ?>
        <div class="faq-item <?php echo $isFirst ? 'open' : ''; ?>">
            <button class="faq-question">
                <span><?php echo esc_html($room); ?></span>
                <span class="arrow">
                    <svg width="18" height="18" viewBox="0 0 23 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.985 14.1575L16.675 9.45L17.9175 10.6925L11.11 17.5L4.30249 10.6925L5.54499 9.45L10.235 14.1575V3.5H11.985V14.1575Z" fill="black"/>
                    </svg>
                </span>
            </button>

            <div class="faq-answer <?php echo $isFirst ? 'active' : ''; ?>">
                <div class="faq-grid">
                    <?php foreach ($room_names as $j => $room_field) : ?>
                        <?php if ($j > 0 && !empty($room_values[$j][$i])) : ?>
                            <div class="faq-detail">
                                <span class="detail-label"><?php echo esc_html($room_field); ?>:</span>
                                <span class="value"><?php echo esc_html($room_values[$j][$i]); ?></span>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php $isFirst = false; ?>
    <?php endforeach; ?>
</div>
					</div>
				</div>
			<?php endif; ?>
			<?php if ($sf['DocumentsCount']) : ?>
				<div class="bg-rounted documents-section listing-section">
					<h2 class="flexmls-title-larger flexmls-primary-color-font flexmls-heading-font">Documents</h2>
					<div class="flexmls-documents-wrapper">
						<?php $fmc_colorbox_extensions = ['gif', 'png']; ?>
						<?php foreach ($sf['Documents'] as $fmc_document) : ?>
							<?php if ($fmc_document['Privacy'] == 'Public') : ?>
								<?php
								$fmc_extension = explode('.', $fmc_document['Uri']);
								$fmc_extension = ($fmc_extension[count($fmc_extension) - 1]);
								if ($fmc_extension == 'pdf') {
									$fmc_file_image = $fmc_plugin_url . '/assets/images/pdf-tiny.gif';
									$fmc_docs_class = "class='fmc_document fmc_document_pdf'";
								} elseif (in_array($fmc_extension, $fmc_colorbox_extensions)) {
									$fmc_file_image = $fmc_plugin_url . '/assets/images/image_16.gif';
									$fmc_docs_class = "class='fmc_document fmc_document_colorbox'";
								} else {
									$fmc_file_image = $fmc_plugin_url . '/assets/images/docs_16.gif';
								}

								echo "<div><a $fmc_docs_class value={$fmc_document['Uri']}><img src='{$fmc_file_image}' align='absmiddle' alt='View Document' title='View Document' /> {$fmc_document['Name']} &rsaquo;</a></div>";
								?>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>
				</div>
			<?php endif; ?>
			<?php if (isset($options['google_maps_api_key']) && $options['google_maps_api_key'] && flexmlsConnect::is_not_blank_or_restricted($sf['Latitude']) && flexmlsConnect::is_not_blank_or_restricted($sf['Longitude'])) : ?>
				<div class="map-section listing-section bg-rounted">
					<div id='flexmls_connect__map_canvas' latitude='<?php echo esc_attr($sf['Latitude']); ?>' longitude='<?php echo esc_attr($sf['Longitude']); ?>'></div>
				</div>
			<?php endif; ?>
		</div>
		<div class="flexmls_detail_sidebar">
			<div class="bg-white rounded-lg shadow-sm p-6 mb-8 bg-rounted">
				<h3 class="text-lg font-bold text-gray-900 mb-4">Property Info</h3>
				<div class="space-y-4">
					<div class="grid grid-cols-2 gap-4 property_basic_info">
						<div>
							<span class="detail_label">ID: </span>
							<span class="detail_value"> MLS# <?php echo $sf['ListingId']; ?></span>
						</div>
						<div>
							<span class="detail_label">Type: </span>
							<span class="detail_value"> <?php echo $sf['PropertyTypeLabel']; ?></span>
						</div>
						<div>
							<span class="detail_label">Status: </span>
							<span class="detail_value"> <?php echo $sf['MlsStatus']; ?></span>
						</div>
						<div>
							<span class="detail_label">Current Price: </span>
							<span class="detail_value">$<?php echo esc_html(flexmlsConnect::gentle_price_rounding($sf['ListPrice'])); ?></span>
						</div>
						<div>
							<span class="detail_value">List Date: </span>
							<span class="detail_value"><?php echo esc_html(date('n/d/Y', strtotime($sf['OnMarketDate']))); ?></span>
						</div>
						<div>
							<span class="detail_value">Listing Office: </span>
							<span class="detail_value"><?php echo $sf['ListOfficeName']; ?></span>
						</div>

					</div>
				</div>
			</div>
			<div class="bg-rounted">
				<h3 class="text-lg font-bold text-gray-900 mb-4">Make this home a reality</h3>
				<div class="flex items-center space-x-3 mb-4">
					<div>
						<p class="text-sm text-gray-600">Find out how much you can afford</p>
					</div>
				</div>
				<div class="w-12 h-12 bg-green-100 rounded-full flex items-center justify-center call_button">
					<span>Call Now: </span>
					<a href="tel:5707157700" class="">(570) 715-7700</a>
				</div>
				<div class="residential_buttons">
					<a href="/buttonre/commercial" class="custom_button">Commercial</a>
					<a href="/buttonre/residential" class="custom_button">Residential</a>
				</div>
			</div>
		</div>
	</div>
	<div id="imagePopup" class="hide fixed inset-0 bg-black bg-opacity-80 z-50 flex items-center justify-center opacity-0 pointer-events-none transition-opacity duration-300">
		<div class="relative w-full max-w-4xl p-4 bg-white rounded-lg popup_container">
			<div id="popupSlider" class="swiper mySwiper">
				<button class="absolute top-2 right-2 text-black text-2xl close_button" id="close_button"> <span> &times; </span> </button>
				<div class="swiper_wrapper">
					<?php foreach ($sf['Photos'] as $p): ?>
						<div class="slider">
							<img src="<?php echo $p['Uri1280']; ?>" alt="" class="w-full h-auto object-contain rounded-lg" />
						</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
	</div>
	<script>
		function changeMainImage(src) {
			document.getElementById('mainImage').src = src;
		}

		document.addEventListener('DOMContentLoaded', function() {
			const popup = document.getElementById('imagePopup');
			const load_more_images = document.getElementById('load_more_images');
			const close_button = document.getElementById('close_button');

			if (load_more_images) {
				load_more_images.addEventListener('click', function() {
					popup.classList.remove('hide');
					popup.classList.add('show');

					if (typeof popupSwiper !== 'undefined') {
						popupSwiper.slideTo(0);
					}
					jQuery('.swiper_wrapper').slick({
						infinite: true,
						slidesToShow: 1,
						slidesToScroll: 1,
						arrows: true,
						dots: false,
						prevArrow: "<button class='custom_previous'> <svg width='18' height='18' viewBox='0 0 18 16' fill='none' xmlns='http://www.w3.org/2000/svg'><path d='M6.20835 7.33331H14.3283V8.66665H6.20835L9.79502 12.24L8.84835 13.1866L3.66168 7.99998L8.84835 2.81331L9.79502 3.75998L6.20835 7.33331Z' fill='#4B5563'/></svg></button>",
						nextArrow: "<button class='custom_next'><svg width='18' height='18' viewBox='0 0 18 16' fill='none' xmlns='http://www.w3.org/2000/svg'><path d='M11.7817 7.33331L8.19508 3.75998L9.14174 2.81331L14.3284 7.99998L9.14174 13.1866L8.19508 12.24L11.7817 8.66665H3.66174V7.33331H11.7817Z' fill='#4B5563'/></svg></button>",
						responsive: [   
							{
								breakpoint: 991,
								settings: {
									slidesToShow: 2,
									slidesToScroll: 2
								}
							},
							{
								breakpoint: 576,
								settings: {
									slidesToShow: 1,
									slidesToScroll: 1
								}
							}
						]
					});
				});
			}

			if (close_button) {
				close_button.addEventListener('click', function() {
					console.log('close button clicked');
					popup.classList.remove('show');
					popup.classList.add('hide');

					setTimeout(() => {
						popup.classList.add('pointer-events-none');
					}, 300);
				});
			}
			
		});
	</script>
</div>